/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.security.strategy.filter.impl;

import com.xforceplus.security.login.context.LoginContext;
import com.xforceplus.security.login.exception.AuthenticationException;
import com.xforceplus.security.login.request.LoginCaptchaRequest;
import com.xforceplus.security.login.request.LoginRequest;
import com.xforceplus.security.strategy.filter.AbstractStrategyFilter;
import com.xforceplus.security.strategy.filter.PostLoadPredicationFilter;
import com.xforceplus.security.strategy.filter.PostLoginFailFilter;
import com.xforceplus.security.strategy.filter.PostLoginSuccessFilter;
import com.xforceplus.security.strategy.model.AccountLoginFailStrategy;
import com.xforceplus.security.strategy.model.CaptchaStrategy;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;

public class FailTimesPredicationStrategyFilter
extends AbstractStrategyFilter<AccountLoginFailStrategy>
implements PostLoadPredicationFilter<AccountLoginFailStrategy>,
PostLoginSuccessFilter<AccountLoginFailStrategy>,
PostLoginFailFilter<AccountLoginFailStrategy> {
    private static final Logger log = LoggerFactory.getLogger(FailTimesPredicationStrategyFilter.class);

    @Override
    public AccountLoginFailStrategy defaultStrategy() {
        return new AccountLoginFailStrategy();
    }

    @Override
    public boolean support(LoginContext<? extends LoginRequest> loginContext) {
        log.debug("execute {}Filter.support", (Object)this.getStrategyClass().getSimpleName());
        if (!PostLoadPredicationFilter.super.support(loginContext)) {
            return false;
        }
        LoginRequest loginRequest = loginContext.getLoginRequest();
        if (loginRequest == null) {
            log.debug("{}Filter.loginContext.loginRequest = null, do nothing", (Object)this.getStrategyClass().getSimpleName());
            return false;
        }
        if (!(loginRequest instanceof LoginCaptchaRequest)) {
            log.debug("{}Filter.loginContext.loginRequest not instanceof LoginCaptchaRequest, do nothing", (Object)this.strategyClass().getSimpleName());
            return false;
        }
        if (loginContext.getLoginName() == null) {
            log.debug("{}Filter.loginContext.loginName = null, do nothing", (Object)this.getStrategyClass().getSimpleName());
            return false;
        }
        return true;
    }

    @Override
    public void executePostLoadPredicate(LoginContext<? extends LoginRequest> loginContext) {
        int captchaThreshold;
        CaptchaStrategy strategy;
        int lockThreshold;
        int times;
        log.debug("{}Filter.executePostLoadPredicate", (Object)this.strategyClass().getSimpleName());
        LoginCaptchaRequest loginRequest = (LoginCaptchaRequest)loginContext.getLoginRequest();
        String loginName = loginContext.getLoginName();
        String redisKey = "ACCOUNT_LOGIN_FAILS_" + loginName;
        StringRedisTemplate redisTemplate = (StringRedisTemplate)this.applicationContext.getBean(StringRedisTemplate.class);
        ValueOperations valueOperations = redisTemplate.opsForValue();
        String redisValue = (String)valueOperations.get((Object)redisKey);
        if (redisValue == null) {
            times = 0;
        } else {
            try {
                times = Integer.parseInt(redisValue);
            }
            catch (NumberFormatException e) {
                times = 0;
            }
        }
        log.debug("times = {}", (Object)times);
        AccountLoginFailStrategy loginFailStrategy = (AccountLoginFailStrategy)this.loadCurrentStrategy(loginContext);
        if (loginFailStrategy == null) {
            loginFailStrategy = new AccountLoginFailStrategy();
        }
        if (loginFailStrategy.isEnabled()) {
            lockThreshold = loginFailStrategy.getThreshold() != null && loginFailStrategy.getThreshold() > 0 ? loginFailStrategy.getThreshold() : 10;
        } else {
            log.debug("{}Filter.AccountLoginFailStrategy disabled, lockThreshold = 0", (Object)this.strategyClass().getSimpleName());
            lockThreshold = 0;
        }
        log.debug("lockThreshold = {}", (Object)lockThreshold);
        if (times >= lockThreshold && lockThreshold > 0) {
            Long expireMinutes = valueOperations.getOperations().getExpire((Object)redisKey, TimeUnit.MINUTES);
            log.debug("expireMinutes = {}", (Object)expireMinutes);
            if (expireMinutes != null && expireMinutes > 0L) {
                String message = AccountLoginFailStrategy.lockMessage(expireMinutes.intValue());
                log.info(message);
                throw new AuthenticationException(0, message);
            }
        }
        if ((strategy = this.loadCurrentStrategy(loginContext, CaptchaStrategy.class)) == null) {
            strategy = new CaptchaStrategy();
        }
        if (strategy.isEnabled()) {
            captchaThreshold = strategy.getThreshold() != null && strategy.getThreshold() > 0 ? strategy.getThreshold() : 1;
        } else {
            log.debug("{}Filter.CaptchaStrategy disabled, captchaThreshold = 0", (Object)this.strategyClass().getSimpleName());
            captchaThreshold = 0;
        }
        log.debug("captchaThreshold = {}", (Object)captchaThreshold);
        String captcha = loginRequest.getCaptcha();
        if (times >= captchaThreshold && captchaThreshold > 0) {
            if (StringUtils.isBlank((CharSequence)captcha)) {
                throw new AuthenticationException(5, "\u8bf7\u8f93\u5165\u9a8c\u8bc1\u7801");
            }
            String captchaKey = "LOGIN_CAPTCHA_" + captcha.toUpperCase();
            boolean exist = redisTemplate.hasKey((Object)captchaKey);
            if (exist) {
                redisTemplate.delete((Object)captchaKey);
            } else {
                String message = "\u9a8c\u8bc1\u7801\u9519\u8bef\uff01";
                log.info(message);
                throw new AuthenticationException(5, message);
            }
        }
    }

    @Override
    public void executePostLoginFail(LoginContext<? extends LoginRequest> loginContext) {
        int timeout;
        int lockThreshold;
        log.debug("execute PostLoginStrategyFilter.executePostLoginFail");
        String loginName = loginContext.getLoginName();
        AccountLoginFailStrategy loginFailStrategy = (AccountLoginFailStrategy)this.loadCurrentStrategy(loginContext);
        if (loginFailStrategy == null) {
            loginFailStrategy = new AccountLoginFailStrategy();
        }
        if (loginFailStrategy.isEnabled()) {
            lockThreshold = loginFailStrategy.getThreshold() != null && loginFailStrategy.getThreshold() > 0 ? loginFailStrategy.getThreshold() : 10;
            timeout = loginFailStrategy.getTimeout() != null && loginFailStrategy.getTimeout() > 0 ? loginFailStrategy.getTimeout() : 30;
        } else {
            log.debug("{}Filter.AccountLoginFailStrategy disabled, lockThreshold = 0", (Object)this.strategyClass().getSimpleName());
            lockThreshold = 0;
            timeout = 30;
        }
        log.debug("lockThreshold = {}", (Object)lockThreshold);
        CaptchaStrategy captchaStrategy = this.loadCurrentStrategy(loginContext, CaptchaStrategy.class);
        if (captchaStrategy == null) {
            captchaStrategy = new CaptchaStrategy();
        }
        int captchaThreshold = captchaStrategy.isEnabled() ? (captchaStrategy.getThreshold() != null && captchaStrategy.getThreshold() > 0 ? captchaStrategy.getThreshold() : 1) : 0;
        log.debug("captchaThreshold = {}", (Object)captchaThreshold);
        log.debug("lockThreshold = {}", (Object)lockThreshold);
        log.debug("timeout = {}", (Object)timeout);
        this.tryLockAccount(loginName, captchaThreshold, lockThreshold, timeout);
    }

    @Override
    public void executePostLoginSuccess(LoginContext<? extends LoginRequest> loginContext) {
        log.debug("execute PostLoginStrategyFilter.executePostLoginSuccess");
        try {
            StringRedisTemplate redisTemplate = (StringRedisTemplate)this.applicationContext.getBean(StringRedisTemplate.class);
            String loginName = loginContext.getLoginName();
            String key = "ACCOUNT_LOGIN_FAILS_" + loginName;
            redisTemplate.delete((Object)key);
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
    }

    private void tryLockAccount(String loginName, int captchaThreshold, int lockThreshold, int timeout) {
        int times;
        log.debug("execute PostLoginStrategyFilter.tryLockAccount");
        String redisKey = "ACCOUNT_LOGIN_FAILS_" + loginName;
        StringRedisTemplate redisTemplate = (StringRedisTemplate)this.applicationContext.getBean(StringRedisTemplate.class);
        String redisValue = (String)redisTemplate.opsForValue().get((Object)redisKey);
        log.debug("redisValue = {}", (Object)redisValue);
        if (redisValue == null) {
            times = 0;
        } else {
            try {
                times = Integer.parseInt(redisValue);
            }
            catch (NumberFormatException e) {
                times = 0;
            }
        }
        ++times;
        try {
            int code = captchaThreshold > 0 && times >= captchaThreshold ? 5 : 0;
            if (lockThreshold > 0) {
                if (times < lockThreshold) {
                    throw new AuthenticationException(code, "\u7528\u6237\u540d/\u5bc6\u7801\u9519\u8bef, \u8fd8\u6709" + (lockThreshold - times) + "\u6b21\u673a\u4f1a");
                }
                String message = AccountLoginFailStrategy.lockMessage(timeout);
                throw new AuthenticationException(0, message);
            }
            throw new AuthenticationException(code, "\u7528\u6237\u540d/\u5bc6\u7801\u9519\u8bef");
        }
        catch (Throwable throwable) {
            log.debug("times = {}", (Object)times);
            redisTemplate.opsForValue().set((Object)redisKey, (Object)String.valueOf(times), (long)timeout, TimeUnit.MINUTES);
            throw throwable;
        }
    }

    protected FailTimesPredicationStrategyFilter(FailTimesPredicationStrategyFilterBuilder<?, ?> b) {
        super(b);
    }

    public static FailTimesPredicationStrategyFilterBuilder<?, ?> builder() {
        return new FailTimesPredicationStrategyFilterBuilderImpl();
    }

    private static final class FailTimesPredicationStrategyFilterBuilderImpl
    extends FailTimesPredicationStrategyFilterBuilder<FailTimesPredicationStrategyFilter, FailTimesPredicationStrategyFilterBuilderImpl> {
        private FailTimesPredicationStrategyFilterBuilderImpl() {
        }

        @Override
        protected FailTimesPredicationStrategyFilterBuilderImpl self() {
            return this;
        }

        @Override
        public FailTimesPredicationStrategyFilter build() {
            return new FailTimesPredicationStrategyFilter(this);
        }
    }

    public static abstract class FailTimesPredicationStrategyFilterBuilder<C extends FailTimesPredicationStrategyFilter, B extends FailTimesPredicationStrategyFilterBuilder<C, B>>
    extends AbstractStrategyFilter.AbstractStrategyFilterBuilder<AccountLoginFailStrategy, C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "FailTimesPredicationStrategyFilter.FailTimesPredicationStrategyFilterBuilder(super=" + super.toString() + ")";
        }
    }
}

