/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.security.strategy.filter.impl;

import com.xforceplus.domain.account.AccountType;
import com.xforceplus.entity.Account;
import com.xforceplus.entity.User;
import com.xforceplus.security.login.context.LoginContext;
import com.xforceplus.security.login.request.LoginRequest;
import com.xforceplus.security.login.response.LoginTokenResponse;
import com.xforceplus.security.login.service.TenantSecretService;
import com.xforceplus.security.strategy.filter.AbstractStrategyFilter;
import com.xforceplus.security.strategy.filter.GenerateTokenFilter;
import com.xforceplus.security.strategy.filter.PostLoginSuccessFilter;
import com.xforceplus.security.strategy.model.GenerateTokenStrategy;
import com.xforceplus.security.strategy.service.StrategyService;
import com.xforceplus.tenant.security.token.domain.TokenUser;
import com.xforceplus.tenant.security.token.encoder.JwtEncoder;
import com.xforceplus.utils.RegExUtil;
import io.geewit.utils.uuid.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.digest.Md5Crypt;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

public class GenerateTokenStrategyFilter
extends AbstractStrategyFilter<GenerateTokenStrategy>
implements GenerateTokenFilter,
PostLoginSuccessFilter<GenerateTokenStrategy> {
    private static final Logger log = LoggerFactory.getLogger(GenerateTokenStrategyFilter.class);
    public static final String TENANT_USER_TOKEN_PREFIX = "tenant:user:token:";
    public static final String TENANT_USER_TOKEN_BLACK_LIST_PREFIX = "tenant:user:token:blacklist:";
    public static final String MD5_SALT = "$1$/v6QjxiQ";

    @Override
    public GenerateTokenStrategy defaultStrategy() {
        return new GenerateTokenStrategy();
    }

    @Override
    public boolean support(LoginContext<? extends LoginRequest> loginContext) {
        log.debug("execute {}Filter.support", (Object)this.strategyClass().getSimpleName());
        if (!GenerateTokenFilter.super.support(loginContext)) {
            return false;
        }
        if (loginContext.getUser() == null) {
            log.debug("this {}Filter.loginContext.user = null, do nothing", (Object)this.strategyClass().getSimpleName());
            return false;
        }
        return true;
    }

    @Override
    public void executeGenerateToken(LoginContext<? extends LoginRequest> loginContext) {
        log.debug("execute {}Filter.executeGenerateToken", (Object)this.strategyClass().getSimpleName());
        User tokenUser = loginContext.getUser();
        if (StringUtils.isBlank((CharSequence)tokenUser.getLoginId())) {
            tokenUser.setLoginId(UUID.randomUUID().toString());
        }
        if (StringUtils.isNotBlank((CharSequence)tokenUser.getUserName())) {
            tokenUser.setUsername(tokenUser.getUserName());
        } else if (StringUtils.isBlank((CharSequence)tokenUser.getUsername())) {
            if (StringUtils.isNotBlank((CharSequence)tokenUser.getEmail())) {
                tokenUser.setUsername(tokenUser.getEmail());
            } else if (StringUtils.isNotBlank((CharSequence)tokenUser.getMobile())) {
                tokenUser.setUsername(tokenUser.getMobile());
            }
        }
        Account account = tokenUser.getAccount();
        if (StringUtils.isNotBlank((CharSequence)account.getUsername())) {
            tokenUser.setLoginName(account.getUsername());
        } else if (StringUtils.isNotBlank((CharSequence)account.getEmail())) {
            tokenUser.setLoginName(account.getEmail());
        } else if (StringUtils.isNotBlank((CharSequence)account.getTelPhone())) {
            tokenUser.setLoginName(account.getTelPhone());
        }
        String defaultSecret = this.applicationContext.getEnvironment().getProperty("xforce.tenant.security.jwt.secret", "my_sessionjw_tsecret_xdfdffdsdfdfs");
        String token = JwtEncoder.encode((TokenUser)tokenUser, (String)defaultSecret, TenantSecretService.TENANT_AND_SECRET);
        loginContext.setToken(token);
        LoginTokenResponse response = loginContext.getResponse();
        response.setToken(token);
        response.setPasswdLength(account.getPasswdLength());
        response.setUsername(loginContext.getLoginName());
        response.setTelPhone(account.getTelPhone());
        response.setEmail(account.getEmail());
        boolean isTel = account.getTelPhone() != null && RegExUtil.checkMobile((String)account.getTelPhone());
        boolean isEmail = account.getEmail() != null && RegExUtil.checkEmail((String)account.getEmail());
        AccountType accountType = isTel || isEmail ? AccountType.PHONE_EMAIL : AccountType.OTHER;
        response.setAccountType(accountType);
        loginContext.setSuccess(true);
    }

    @Override
    public void executePostLoginSuccess(LoginContext<? extends LoginRequest> loginContext) {
        log.debug("execute {}Filter.executePostLoginSuccess", (Object)this.strategyClass().getSimpleName());
        StringRedisTemplate redisTemplate = (StringRedisTemplate)this.applicationContext.getBean(StringRedisTemplate.class);
        StrategyService strategyService = (StrategyService)this.applicationContext.getBean(StrategyService.class);
        Long currentTenantId = loginContext.getCurrentTenantId();
        if (currentTenantId == null) {
            log.debug("execute {}Filter.currentTenantId == null, do nothing", (Object)this.strategyClass().getSimpleName());
            return;
        }
        GenerateTokenStrategy strategy = strategyService.loadStrategy(currentTenantId, GenerateTokenStrategy.class);
        if (strategy != null && strategy.isEnabled() && strategy.isSingleSession()) {
            Long userId = loginContext.getUser().getId();
            log.debug("userId = {}", (Object)userId);
            String tokenRedisKey = TENANT_USER_TOKEN_PREFIX + currentTenantId + ":" + userId;
            String lastUserToken = (String)redisTemplate.opsForValue().get((Object)tokenRedisKey);
            String token = loginContext.getToken();
            String tokenMd5 = Md5Crypt.md5Crypt((byte[])token.getBytes(), (String)MD5_SALT);
            if (null != lastUserToken) {
                String blackListRedisKey = TENANT_USER_TOKEN_BLACK_LIST_PREFIX + currentTenantId + ":" + userId;
                log.debug("blackListRedisKey = {}", (Object)blackListRedisKey);
                boolean lastUserTokenBlacked = redisTemplate.opsForSet().isMember((Object)blackListRedisKey, (Object)lastUserToken);
                if (!lastUserTokenBlacked && !lastUserToken.equals(tokenMd5)) {
                    redisTemplate.opsForSet().add((Object)blackListRedisKey, (Object[])new String[]{lastUserToken});
                    redisTemplate.expire((Object)blackListRedisKey, 10L, TimeUnit.HOURS);
                    log.info("\u7528\u6237id:{}\u5df2\u5728\u5176\u4ed6\u5730\u65b9\u767b\u5f55\uff0c\u524d\u4e00\u6b21\u767b\u5f55token\u88ab\u62c9\u9ed1,\u5176md5\u503c\u4e3a: {}", (Object)userId, (Object)lastUserToken);
                }
            }
            redisTemplate.opsForValue().set((Object)tokenRedisKey, (Object)tokenMd5, 10L, TimeUnit.HOURS);
        }
    }

    protected GenerateTokenStrategyFilter(GenerateTokenStrategyFilterBuilder<?, ?> b) {
        super(b);
    }

    public static GenerateTokenStrategyFilterBuilder<?, ?> builder() {
        return new GenerateTokenStrategyFilterBuilderImpl();
    }

    private static final class GenerateTokenStrategyFilterBuilderImpl
    extends GenerateTokenStrategyFilterBuilder<GenerateTokenStrategyFilter, GenerateTokenStrategyFilterBuilderImpl> {
        private GenerateTokenStrategyFilterBuilderImpl() {
        }

        @Override
        protected GenerateTokenStrategyFilterBuilderImpl self() {
            return this;
        }

        @Override
        public GenerateTokenStrategyFilter build() {
            return new GenerateTokenStrategyFilter(this);
        }
    }

    public static abstract class GenerateTokenStrategyFilterBuilder<C extends GenerateTokenStrategyFilter, B extends GenerateTokenStrategyFilterBuilder<C, B>>
    extends AbstractStrategyFilter.AbstractStrategyFilterBuilder<GenerateTokenStrategy, C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "GenerateTokenStrategyFilter.GenerateTokenStrategyFilterBuilder(super=" + super.toString() + ")";
        }
    }
}

