/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.security.strategy.filter.impl;

import com.xforceplus.business.tenant.service.UserService;
import com.xforceplus.entity.Account;
import com.xforceplus.entity.User;
import com.xforceplus.security.login.context.LoginContext;
import com.xforceplus.security.login.exception.AuthenticationException;
import com.xforceplus.security.login.request.LoginRequest;
import com.xforceplus.security.login.request.PasswordLoginRequest;
import com.xforceplus.security.strategy.filter.AbstractStrategyFilter;
import com.xforceplus.security.strategy.filter.LoadUserFilter;
import com.xforceplus.security.strategy.model.LoadUserByPasswordStrategy;
import com.xforceplus.utils.DateUtils;
import java.util.Date;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadUserByPasswordStrategyFilter
extends AbstractStrategyFilter<LoadUserByPasswordStrategy>
implements LoadUserFilter<LoadUserByPasswordStrategy> {
    private static final Logger log = LoggerFactory.getLogger(LoadUserByPasswordStrategyFilter.class);

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    public LoadUserByPasswordStrategy defaultStrategy() {
        return new LoadUserByPasswordStrategy();
    }

    @Override
    public boolean support(LoginContext<? extends LoginRequest> loginContext) {
        log.debug("execute {}Filter.support", (Object)this.strategyClass().getSimpleName());
        if (!LoadUserFilter.super.support(loginContext)) {
            return false;
        }
        LoginRequest loginRequest = loginContext.getLoginRequest();
        if (loginRequest == null) {
            log.debug("this {}Filter.loginContext.loginRequest = null, do nothing", (Object)this.strategyClass().getSimpleName());
            return false;
        }
        if (!(loginRequest instanceof PasswordLoginRequest)) {
            log.debug("this {}Filter.loginContext.loginRequest not instanceof PasswordLoginRequest, do nothing", (Object)this.strategyClass().getSimpleName());
            return false;
        }
        return true;
    }

    @Override
    public void executeLoadUser(LoginContext<? extends LoginRequest> loginContext) {
        User user;
        log.debug("execute {}Filter.executeLoadUser", (Object)this.strategyClass().getSimpleName());
        PasswordLoginRequest loginRequest = (PasswordLoginRequest)loginContext.getLoginRequest();
        String username = loginRequest.getUsername();
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new AuthenticationException(0, "\u767b\u5f55\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (loginContext.getLoginName() == null) {
            loginContext.setLoginName(username);
        }
        UserService userService = (UserService)this.applicationContext.getBean(UserService.class);
        if (StringUtils.isNotBlank((CharSequence)loginRequest.getTenantCode())) {
            user = userService.findByTenantCodeAndUsername(loginRequest.getTenantCode(), username, 0);
            if (user != null) {
                Long tenantId = user.getTenantId();
                user.setTenantIds(Stream.of(tenantId).collect(Collectors.toSet()));
            }
        } else {
            user = userService.findByUsername(username, 0);
        }
        if (user == null) {
            throw new IllegalArgumentException("\u7528\u6237\u540d\u5bc6\u7801\u9519\u8bef");
        }
        loginContext.setAccountId(user.getAccountId());
        loginContext.setTenantIds(user.getTenantIds());
        if (user.getExpiredDate() != null && DateUtils.beforeNow((Date)user.getExpiredDate(), (boolean)false)) {
            throw new AuthenticationException(0, "\u7528\u6237\u5df2\u8fc7\u671f");
        }
        Account account = user.getAccount();
        user.setModules(loginRequest.getModules());
        loginContext.setUser(user);
        loginContext.setAccount(account);
        loginContext.setCurrentTenantId(user.getTenantId());
    }

    protected LoadUserByPasswordStrategyFilter(LoadUserByPasswordStrategyFilterBuilder<?, ?> b) {
        super(b);
    }

    public static LoadUserByPasswordStrategyFilterBuilder<?, ?> builder() {
        return new LoadUserByPasswordStrategyFilterBuilderImpl();
    }

    private static final class LoadUserByPasswordStrategyFilterBuilderImpl
    extends LoadUserByPasswordStrategyFilterBuilder<LoadUserByPasswordStrategyFilter, LoadUserByPasswordStrategyFilterBuilderImpl> {
        private LoadUserByPasswordStrategyFilterBuilderImpl() {
        }

        @Override
        protected LoadUserByPasswordStrategyFilterBuilderImpl self() {
            return this;
        }

        @Override
        public LoadUserByPasswordStrategyFilter build() {
            return new LoadUserByPasswordStrategyFilter(this);
        }
    }

    public static abstract class LoadUserByPasswordStrategyFilterBuilder<C extends LoadUserByPasswordStrategyFilter, B extends LoadUserByPasswordStrategyFilterBuilder<C, B>>
    extends AbstractStrategyFilter.AbstractStrategyFilterBuilder<LoadUserByPasswordStrategy, C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "LoadUserByPasswordStrategyFilter.LoadUserByPasswordStrategyFilterBuilder(super=" + super.toString() + ")";
        }
    }
}

