/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.security.strategy.filter.impl;

import com.xforceplus.business.tenant.service.UserService;
import com.xforceplus.entity.User;
import com.xforceplus.security.login.context.LoginContext;
import com.xforceplus.security.login.exception.AuthenticationException;
import com.xforceplus.security.login.request.LoginRequest;
import com.xforceplus.security.login.request.SmsLoginRequest;
import com.xforceplus.security.strategy.filter.AbstractStrategyFilter;
import com.xforceplus.security.strategy.filter.LoadUserFilter;
import com.xforceplus.security.strategy.model.LoadUserBySmsStrategy;
import com.xforceplus.utils.DateUtils;
import com.xforceplus.utils.RegExUtil;
import com.xforececlound.message.api.SmsAuthCodeApi;
import com.xforececlound.message.model.SmsValidateReq;
import com.xforececlound.message.model.SmsValidateResp;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class LoadUserBySmsStrategyFilter
extends AbstractStrategyFilter<LoadUserBySmsStrategy>
implements LoadUserFilter<LoadUserBySmsStrategy> {
    private static final Logger log = LoggerFactory.getLogger(LoadUserBySmsStrategyFilter.class);
    private static final String TWO_FACTOR_PWD_PREFIX = "TWO_FACTOR_PWD_";
    private static final String TWO_FACTOR_CODE_PREFIX = "TWO_FACTOR_CODE_";
    private int priority;
    private ApplicationContext applicationContext;

    @Override
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    public LoadUserBySmsStrategy defaultStrategy() {
        return new LoadUserBySmsStrategy();
    }

    @Override
    public boolean support(LoginContext<? extends LoginRequest> loginContext) {
        log.debug("execute {}Filter.support", (Object)this.strategyClass().getSimpleName());
        if (!LoadUserFilter.super.support(loginContext)) {
            return false;
        }
        LoginRequest loginRequest = loginContext.getLoginRequest();
        if (loginRequest == null) {
            log.debug("this {}Filter.loginContext.loginRequest = null, do nothing", (Object)this.strategyClass().getSimpleName());
            return false;
        }
        if (!(loginRequest instanceof SmsLoginRequest)) {
            log.debug("this {}Handler.loginContext.loginRequest not instanceof SmsLoginRequest, do nothing", (Object)this.strategyClass().getSimpleName());
            return false;
        }
        return true;
    }

    @Override
    public void executeLoadUser(LoginContext<? extends LoginRequest> loginContext) {
        boolean checked;
        User user;
        log.debug("execute {}Filter.executeLoadUser", (Object)this.strategyClass().getSimpleName());
        SmsLoginRequest loginRequest = (SmsLoginRequest)loginContext.getLoginRequest();
        loginContext.setLoginName(loginRequest.getPhone());
        LoadUserBySmsStrategy strategy = (LoadUserBySmsStrategy)this.loadCurrentStrategy(loginContext);
        if (strategy == null || !strategy.isEnabled()) {
            log.debug("execute {}Filter.strategy disabled, do nothing", (Object)this.strategyClass().getSimpleName());
            return;
        }
        if (StringUtils.isBlank((CharSequence)loginRequest.getMsgId())) {
            throw new AuthenticationException(0, "\u8bf7\u5148\u53d1\u9001\u9a8c\u8bc1\u7801\u3002");
        }
        String phone = loginRequest.getPhone();
        if (!RegExUtil.checkMobile((String)phone)) {
            throw new AuthenticationException(0, "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7\u7801\uff01");
        }
        loginContext.setLoginName(phone);
        try {
            UserService userService = (UserService)this.applicationContext.getBean(UserService.class);
            user = userService.findByUsername(phone, 0);
        }
        catch (Exception e) {
            throw new AuthenticationException(0, "\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\u4fe1\u606f\uff01");
        }
        if (user == null) {
            throw new AuthenticationException(0, "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7\u7801\uff01");
        }
        if (user.getExpiredDate() != null && DateUtils.beforeNow((Date)user.getExpiredDate(), (boolean)false)) {
            throw new AuthenticationException(0, "\u7528\u6237\u5df2\u8fc7\u671f");
        }
        SmsValidateReq smsValidateReq = new SmsValidateReq();
        smsValidateReq.setMsgId(loginRequest.getMsgId());
        smsValidateReq.setMobile(loginRequest.getPhone());
        smsValidateReq.setCode(loginRequest.getSmsCode());
        SmsAuthCodeApi smsAuthCodeApi = (SmsAuthCodeApi)this.applicationContext.getBean(SmsAuthCodeApi.class);
        SmsValidateResp smsValidateResp = smsAuthCodeApi.validate(String.valueOf(user.getTenantId()), smsValidateReq);
        boolean bl = checked = smsValidateResp != null && smsValidateResp.isCheck();
        if (!checked) {
            throw new AuthenticationException(0, "\u9a8c\u8bc1\u7801\u9a8c\u8bc1\u5931\u8d25\u3002");
        }
        loginContext.setUser(user);
        loginContext.setAccount(user.getAccount());
        loginContext.setTenantIds(user.getTenantIds());
        loginContext.setCurrentTenantId(user.getTenantId());
    }

    protected LoadUserBySmsStrategyFilter(LoadUserBySmsStrategyFilterBuilder<?, ?> b) {
        super(b);
        this.priority = ((LoadUserBySmsStrategyFilterBuilder)b).priority;
        this.applicationContext = ((LoadUserBySmsStrategyFilterBuilder)b).applicationContext;
    }

    public static LoadUserBySmsStrategyFilterBuilder<?, ?> builder() {
        return new LoadUserBySmsStrategyFilterBuilderImpl();
    }

    private static final class LoadUserBySmsStrategyFilterBuilderImpl
    extends LoadUserBySmsStrategyFilterBuilder<LoadUserBySmsStrategyFilter, LoadUserBySmsStrategyFilterBuilderImpl> {
        private LoadUserBySmsStrategyFilterBuilderImpl() {
        }

        @Override
        protected LoadUserBySmsStrategyFilterBuilderImpl self() {
            return this;
        }

        @Override
        public LoadUserBySmsStrategyFilter build() {
            return new LoadUserBySmsStrategyFilter(this);
        }
    }

    public static abstract class LoadUserBySmsStrategyFilterBuilder<C extends LoadUserBySmsStrategyFilter, B extends LoadUserBySmsStrategyFilterBuilder<C, B>>
    extends AbstractStrategyFilter.AbstractStrategyFilterBuilder<LoadUserBySmsStrategy, C, B> {
        private int priority;
        private ApplicationContext applicationContext;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public B priority(int priority) {
            this.priority = priority;
            return (B)this.self();
        }

        @Override
        public B applicationContext(ApplicationContext applicationContext) {
            this.applicationContext = applicationContext;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "LoadUserBySmsStrategyFilter.LoadUserBySmsStrategyFilterBuilder(super=" + super.toString() + ", priority=" + this.priority + ", applicationContext=" + this.applicationContext + ")";
        }
    }
}

