/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.security.strategy.filter.impl;

import com.xforceplus.entity.Account;
import com.xforceplus.security.login.context.LoginContext;
import com.xforceplus.security.login.exception.AuthenticationException;
import com.xforceplus.security.login.request.LoginRequest;
import com.xforceplus.security.login.response.LoginTokenResponse;
import com.xforceplus.security.strategy.filter.AbstractStrategyFilter;
import com.xforceplus.security.strategy.filter.PostLoadValidationFilter;
import com.xforceplus.security.strategy.model.PasswordExpiredStrategy;
import java.sql.Date;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordExpiredStrategyFilter
extends AbstractStrategyFilter<PasswordExpiredStrategy>
implements PostLoadValidationFilter<PasswordExpiredStrategy> {
    private static final Logger log = LoggerFactory.getLogger(PasswordExpiredStrategyFilter.class);

    @Override
    public PasswordExpiredStrategy defaultStrategy() {
        return new PasswordExpiredStrategy();
    }

    @Override
    public boolean support(LoginContext<? extends LoginRequest> loginContext) {
        log.debug("execute {}Filter.support", (Object)this.strategyClass().getSimpleName());
        if (!PostLoadValidationFilter.super.support(loginContext)) {
            return false;
        }
        LoginRequest loginRequest = loginContext.getLoginRequest();
        if (loginRequest == null) {
            log.debug("this {}Filter.loginContext.loginRequest = null, do nothing", (Object)this.strategyClass().getSimpleName());
            return false;
        }
        Account account = loginContext.getAccount();
        if (account == null) {
            log.debug("this {}Filter.loginContext.account = null, do nothing", (Object)this.strategyClass().getSimpleName());
            return false;
        }
        return true;
    }

    @Override
    public void executePostLoadValid(LoginContext<? extends LoginRequest> loginContext) {
        int expireRemindDays;
        log.debug("execute {}Filter.executePostLoadValid", (Object)this.strategyClass().getSimpleName());
        PasswordExpiredStrategy strategy = (PasswordExpiredStrategy)this.loadCurrentStrategy(loginContext);
        if (strategy == null || !strategy.isEnabled()) {
            log.debug("execute {}Filter.strategy disabled, do nothing", (Object)this.strategyClass().getSimpleName());
            return;
        }
        Account account = loginContext.getAccount();
        LoginTokenResponse response = loginContext.getResponse();
        if (response == null) {
            response = LoginTokenResponse.builder().build();
            loginContext.setResponse(response);
        }
        int expireDays = strategy.getExpireDays() != null && strategy.getExpireDays() > 0 ? strategy.getExpireDays() : 90;
        int n = expireRemindDays = strategy.getExpireRemindDays() != null && strategy.getExpireRemindDays() > 0 ? strategy.getExpireRemindDays() : 30;
        if (account.getPwdLastUpdateTime() != null) {
            boolean pwdExpireFlag;
            LocalDate pwdLastUpdateDate = account.getPwdLastUpdateTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            boolean modifyPasswordTip = pwdLastUpdateDate.plusDays(expireDays).compareTo(LocalDate.now()) <= 0;
            response.setModifyPasswordTip(modifyPasswordTip);
            response.setUsername(loginContext.getLoginName());
            if (modifyPasswordTip) {
                throw new AuthenticationException(6, "\u8bf7\u4fee\u6539\u5bc6\u7801", response);
            }
            boolean bl = pwdExpireFlag = pwdLastUpdateDate.plusDays(expireDays - expireRemindDays).compareTo(LocalDate.now()) <= 0;
            if (pwdExpireFlag) {
                log.debug("this {}Filter.pwdExpireFlag = true", (Object)this.strategyClass().getSimpleName());
                LocalDate expireDate = pwdLastUpdateDate.plusDays(expireDays);
                Instant expireInstant = expireDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
                response.setPwdExpireDate(Date.from(expireInstant));
            }
        } else {
            log.debug("this {}Filter.account.getPwdLastUpdateTime() != null, modifyPasswordTip = false", (Object)this.strategyClass().getSimpleName());
            response.setModifyPasswordTip(false);
        }
    }

    protected PasswordExpiredStrategyFilter(PasswordExpiredStrategyFilterBuilder<?, ?> b) {
        super(b);
    }

    public static PasswordExpiredStrategyFilterBuilder<?, ?> builder() {
        return new PasswordExpiredStrategyFilterBuilderImpl();
    }

    private static final class PasswordExpiredStrategyFilterBuilderImpl
    extends PasswordExpiredStrategyFilterBuilder<PasswordExpiredStrategyFilter, PasswordExpiredStrategyFilterBuilderImpl> {
        private PasswordExpiredStrategyFilterBuilderImpl() {
        }

        @Override
        protected PasswordExpiredStrategyFilterBuilderImpl self() {
            return this;
        }

        @Override
        public PasswordExpiredStrategyFilter build() {
            return new PasswordExpiredStrategyFilter(this);
        }
    }

    public static abstract class PasswordExpiredStrategyFilterBuilder<C extends PasswordExpiredStrategyFilter, B extends PasswordExpiredStrategyFilterBuilder<C, B>>
    extends AbstractStrategyFilter.AbstractStrategyFilterBuilder<PasswordExpiredStrategy, C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "PasswordExpiredStrategyFilter.PasswordExpiredStrategyFilterBuilder(super=" + super.toString() + ")";
        }
    }
}

