/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.security.strategy.filter.impl;

import com.xforceplus.security.login.context.LoginContext;
import com.xforceplus.security.login.request.LoginPasswordRequest;
import com.xforceplus.security.login.request.LoginRequest;
import com.xforceplus.security.login.response.LoginTokenResponse;
import com.xforceplus.security.strategy.filter.AbstractStrategyFilter;
import com.xforceplus.security.strategy.filter.PostLoadValidationFilter;
import com.xforceplus.security.strategy.model.PasswordPatternStrategy;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordPatternStrategyFilter
extends AbstractStrategyFilter<PasswordPatternStrategy>
implements PostLoadValidationFilter<PasswordPatternStrategy> {
    private static final Logger log = LoggerFactory.getLogger(PasswordPatternStrategyFilter.class);

    @Override
    public PasswordPatternStrategy defaultStrategy() {
        return new PasswordPatternStrategy();
    }

    @Override
    public boolean support(LoginContext<? extends LoginRequest> loginContext) {
        log.debug("execute {}Filter.support", (Object)this.strategyClass().getSimpleName());
        if (!PostLoadValidationFilter.super.support(loginContext)) {
            return false;
        }
        LoginRequest loginRequest = loginContext.getLoginRequest();
        if (loginRequest == null) {
            log.debug("this {}Filter.loginContext.loginRequest = null, do nothing", (Object)this.strategyClass().getSimpleName());
            return false;
        }
        if (!(loginRequest instanceof LoginPasswordRequest)) {
            log.debug("this {}Filter.loginContext.loginRequest not instanceof LoginPasswordRequest, do nothing", (Object)this.strategyClass().getSimpleName());
            return false;
        }
        return true;
    }

    @Override
    public void executePostLoadValid(LoginContext<? extends LoginRequest> loginContext) {
        log.debug("execute {}Filter.executePostLoadValid", (Object)this.strategyClass().getSimpleName());
        LoginPasswordRequest loginRequest = (LoginPasswordRequest)loginContext.getLoginRequest();
        String password = loginRequest.getPassword();
        if (password == null) {
            throw new IllegalArgumentException("\u767b\u5f55\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PasswordPatternStrategy strategy = (PasswordPatternStrategy)this.loadCurrentStrategy(loginContext);
        if (strategy == null || !strategy.isEnabled()) {
            log.debug("execute {}Filter.strategy disabled, do nothing", (Object)this.strategyClass().getSimpleName());
            return;
        }
        Pattern pattern = PasswordPatternStrategy.findPattern(strategy.getPattern());
        if (!pattern.matcher(password).matches()) {
            throw new IllegalArgumentException(strategy.getMessage());
        }
        LoginTokenResponse response = loginContext.getResponse();
        if (response != null) {
            if (response.getPasswdLength() != null && response.getPasswdLength() > 0) {
                return;
            }
        } else {
            response = LoginTokenResponse.builder().build();
            loginContext.setResponse(response);
        }
        response.setPasswdLength(strategy.minLength());
    }

    protected PasswordPatternStrategyFilter(PasswordPatternStrategyFilterBuilder<?, ?> b) {
        super(b);
    }

    public static PasswordPatternStrategyFilterBuilder<?, ?> builder() {
        return new PasswordPatternStrategyFilterBuilderImpl();
    }

    private static final class PasswordPatternStrategyFilterBuilderImpl
    extends PasswordPatternStrategyFilterBuilder<PasswordPatternStrategyFilter, PasswordPatternStrategyFilterBuilderImpl> {
        private PasswordPatternStrategyFilterBuilderImpl() {
        }

        @Override
        protected PasswordPatternStrategyFilterBuilderImpl self() {
            return this;
        }

        @Override
        public PasswordPatternStrategyFilter build() {
            return new PasswordPatternStrategyFilter(this);
        }
    }

    public static abstract class PasswordPatternStrategyFilterBuilder<C extends PasswordPatternStrategyFilter, B extends PasswordPatternStrategyFilterBuilder<C, B>>
    extends AbstractStrategyFilter.AbstractStrategyFilterBuilder<PasswordPatternStrategy, C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "PasswordPatternStrategyFilter.PasswordPatternStrategyFilterBuilder(super=" + super.toString() + ")";
        }
    }
}

