/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.security.strategy.filter.impl;

import com.xforceplus.entity.Account;
import com.xforceplus.security.login.context.LoginContext;
import com.xforceplus.security.login.request.LoginPasswordRequest;
import com.xforceplus.security.login.request.LoginRequest;
import com.xforceplus.security.strategy.filter.AbstractStrategyFilter;
import com.xforceplus.security.strategy.filter.PostLoadValidationFilter;
import com.xforceplus.security.strategy.model.LoadUserByPasswordStrategy;
import com.xforceplus.tenant.security.core.utils.CryptUtils;
import com.xforceplus.utils.AESHelp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordValidationStrategyFilter
extends AbstractStrategyFilter<LoadUserByPasswordStrategy>
implements PostLoadValidationFilter<LoadUserByPasswordStrategy> {
    private static final Logger log = LoggerFactory.getLogger(PasswordValidationStrategyFilter.class);

    @Override
    public LoadUserByPasswordStrategy defaultStrategy() {
        return new LoadUserByPasswordStrategy();
    }

    @Override
    public boolean support(LoginContext<? extends LoginRequest> loginContext) {
        log.debug("execute {}Filter.support", (Object)this.getStrategyClass().getSimpleName());
        if (!PostLoadValidationFilter.super.support(loginContext)) {
            return false;
        }
        LoginRequest loginRequest = loginContext.getLoginRequest();
        if (loginRequest == null) {
            log.debug("{}Filter.loginContext.loginRequest = null, do nothing", (Object)this.getStrategyClass().getSimpleName());
            return false;
        }
        if (!(loginRequest instanceof LoginPasswordRequest)) {
            log.debug("{}Filter.loginContext.loginRequest not instanceof LoginPasswordRequest, do nothing", (Object)this.strategyClass().getSimpleName());
            return false;
        }
        if (loginContext.getAccount() == null) {
            log.debug("{}Filter.loginContext.account = null, do nothing", (Object)this.getStrategyClass().getSimpleName());
            return false;
        }
        return true;
    }

    @Override
    public void executePostLoadValid(LoginContext<? extends LoginRequest> loginContext) {
        String password;
        log.debug("{}Filter.executePostLoadValid", (Object)this.strategyClass().getSimpleName());
        LoginPasswordRequest loginRequest = (LoginPasswordRequest)loginContext.getLoginRequest();
        Account account = loginContext.getAccount();
        if (loginContext.isNeedEncrypt()) {
            try {
                password = AESHelp.desEncrypt((String)"Key#password%Key", (String)loginRequest.getPassword());
                loginRequest.setPassword(password);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u7528\u6237\u540d\u5bc6\u7801\u9519\u8bef");
            }
        } else {
            password = loginRequest.getPassword();
        }
        String salt = this.applicationContext.getEnvironment().getProperty("tenant.security.password.salt", "");
        String encryptedPassword = CryptUtils.encryptPassword((String)account.getSalt(), (String)password, (String)salt);
        if (!encryptedPassword.equals(account.getPassword())) {
            throw new IllegalArgumentException("\u7528\u6237\u540d\u5bc6\u7801\u9519\u8bef");
        }
    }

    protected PasswordValidationStrategyFilter(PasswordValidationStrategyFilterBuilder<?, ?> b) {
        super(b);
    }

    public static PasswordValidationStrategyFilterBuilder<?, ?> builder() {
        return new PasswordValidationStrategyFilterBuilderImpl();
    }

    private static final class PasswordValidationStrategyFilterBuilderImpl
    extends PasswordValidationStrategyFilterBuilder<PasswordValidationStrategyFilter, PasswordValidationStrategyFilterBuilderImpl> {
        private PasswordValidationStrategyFilterBuilderImpl() {
        }

        @Override
        protected PasswordValidationStrategyFilterBuilderImpl self() {
            return this;
        }

        @Override
        public PasswordValidationStrategyFilter build() {
            return new PasswordValidationStrategyFilter(this);
        }
    }

    public static abstract class PasswordValidationStrategyFilterBuilder<C extends PasswordValidationStrategyFilter, B extends PasswordValidationStrategyFilterBuilder<C, B>>
    extends AbstractStrategyFilter.AbstractStrategyFilterBuilder<LoadUserByPasswordStrategy, C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "PasswordValidationStrategyFilter.PasswordValidationStrategyFilterBuilder(super=" + super.toString() + ")";
        }
    }
}

