/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.security.strategy.filter.impl;

import com.xforceplus.domain.account.AccountType;
import com.xforceplus.entity.Account;
import com.xforceplus.entity.User;
import com.xforceplus.security.login.context.LoginContext;
import com.xforceplus.security.login.exception.AuthenticationException;
import com.xforceplus.security.login.request.LoginRequest;
import com.xforceplus.security.login.request.PasswordLoginRequest;
import com.xforceplus.security.login.response.LoginTokenResponse;
import com.xforceplus.security.strategy.filter.AbstractStrategyFilter;
import com.xforceplus.security.strategy.filter.PostLoadValidationFilter;
import com.xforceplus.security.strategy.model.PostLoadUserStrategy;
import com.xforceplus.utils.DateUtils;
import com.xforceplus.utils.RegExUtil;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostLoadUserStrategyFilter
extends AbstractStrategyFilter<PostLoadUserStrategy>
implements PostLoadValidationFilter<PostLoadUserStrategy> {
    private static final Logger log = LoggerFactory.getLogger(PostLoadUserStrategyFilter.class);

    @Override
    public PostLoadUserStrategy defaultStrategy() {
        return new PostLoadUserStrategy();
    }

    @Override
    public boolean support(LoginContext<? extends LoginRequest> loginContext) {
        log.debug("execute {}Filter.support", (Object)this.strategyClass().getSimpleName());
        if (!PostLoadValidationFilter.super.support(loginContext)) {
            return false;
        }
        if (loginContext.getUser() == null || loginContext.getAccount() == null) {
            throw new AuthenticationException(0, "\u83b7\u53d6\u7528\u6237\u5931\u8d25");
        }
        return true;
    }

    @Override
    public void executePostLoadValid(LoginContext<? extends LoginRequest> loginContext) {
        log.debug("execute {}Filter.executePostLoadValid", (Object)this.strategyClass().getSimpleName());
        User user = loginContext.getUser();
        Account account = loginContext.getAccount();
        PostLoadUserStrategy strategy = (PostLoadUserStrategy)this.loadCurrentStrategy(loginContext);
        if (strategy == null || !strategy.isEnabled()) {
            log.debug("execute {}Filter.strategy disabled, do nothing", (Object)this.strategyClass().getSimpleName());
            return;
        }
        if (strategy.isCheckAccountStatus() && (account.getStatus() == null || account.getStatus() != 1)) {
            throw new AuthenticationException(0, "\u8d26\u53f7\u672a\u542f\u7528");
        }
        if (strategy.isCheckUserStatus() && (user.getStatus() == null || user.getStatus() != 1)) {
            throw new AuthenticationException(0, "\u7528\u6237\u672a\u542f\u7528");
        }
        if (user.getExpiredDate() != null && DateUtils.beforeNow((Date)user.getExpiredDate(), (boolean)false)) {
            throw new AuthenticationException(0, "\u7528\u6237\u5df2\u8fc7\u671f");
        }
        LoginRequest loginRequest = loginContext.getLoginRequest();
        if (loginRequest instanceof PasswordLoginRequest) {
            boolean isTel = account.getTelPhone() != null && RegExUtil.checkMobile((String)account.getTelPhone());
            boolean isEmail = account.getEmail() != null && RegExUtil.checkEmail((String)account.getEmail());
            AccountType accountType = isTel || isEmail ? AccountType.PHONE_EMAIL : AccountType.OTHER;
            LoginTokenResponse response = loginContext.getResponse();
            if (response == null) {
                response = LoginTokenResponse.builder().build();
                loginContext.setResponse(response);
            }
            response.setAccountType(accountType);
            response.setPasswdLength(account.getPasswdLength());
            if (account.getChangePasswordFlag() != null && account.getChangePasswordFlag().booleanValue()) {
                response.setUsername(StringUtils.defaultString((String)loginContext.getLoginName(), (String)account.getUsername()));
                throw new AuthenticationException(6, "\u8bf7\u4fee\u6539\u5bc6\u7801", response);
            }
            if (account.getBindAuthFlag() != null && account.getBindAuthFlag().booleanValue()) {
                response.setUsername(StringUtils.defaultString((String)loginContext.getLoginName(), (String)account.getUsername()));
                throw new AuthenticationException(7, "\u7ed1\u5b9a\u624b\u673a\u6216\u8005\u90ae\u7bb1", response);
            }
        }
    }

    protected PostLoadUserStrategyFilter(PostLoadUserStrategyFilterBuilder<?, ?> b) {
        super(b);
    }

    public static PostLoadUserStrategyFilterBuilder<?, ?> builder() {
        return new PostLoadUserStrategyFilterBuilderImpl();
    }

    private static final class PostLoadUserStrategyFilterBuilderImpl
    extends PostLoadUserStrategyFilterBuilder<PostLoadUserStrategyFilter, PostLoadUserStrategyFilterBuilderImpl> {
        private PostLoadUserStrategyFilterBuilderImpl() {
        }

        @Override
        protected PostLoadUserStrategyFilterBuilderImpl self() {
            return this;
        }

        @Override
        public PostLoadUserStrategyFilter build() {
            return new PostLoadUserStrategyFilter(this);
        }
    }

    public static abstract class PostLoadUserStrategyFilterBuilder<C extends PostLoadUserStrategyFilter, B extends PostLoadUserStrategyFilterBuilder<C, B>>
    extends AbstractStrategyFilter.AbstractStrategyFilterBuilder<PostLoadUserStrategy, C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "PostLoadUserStrategyFilter.PostLoadUserStrategyFilterBuilder(super=" + super.toString() + ")";
        }
    }
}

