/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.security.strategy.filter.impl;

import com.xforceplus.entity.User;
import com.xforceplus.security.login.context.LoginContext;
import com.xforceplus.security.login.request.LoginRequest;
import com.xforceplus.security.strategy.filter.AbstractStrategyFilter;
import com.xforceplus.security.strategy.filter.PostGenerateTokenFilter;
import com.xforceplus.security.strategy.model.ResponseCookieStrategy;
import com.xforceplus.security.utils.CookieUtils;
import com.xforceplus.tenant.security.token.domain.UserType;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseCookie;
import org.springframework.web.util.UriUtils;

public class ResponseCookieStrategyFilter
extends AbstractStrategyFilter<ResponseCookieStrategy>
implements PostGenerateTokenFilter<ResponseCookieStrategy> {
    private static final Logger log = LoggerFactory.getLogger(ResponseCookieStrategyFilter.class);

    @Override
    public ResponseCookieStrategy defaultStrategy() {
        return new ResponseCookieStrategy();
    }

    @Override
    public boolean support(LoginContext<? extends LoginRequest> loginContext) {
        log.debug("execute {}Filter.support", (Object)this.strategyClass().getSimpleName());
        return PostGenerateTokenFilter.super.support(loginContext);
    }

    @Override
    public void executePostGenerateToken(LoginContext<? extends LoginRequest> loginContext) {
        log.debug("execute {}Filter.executePostGenerateToken", (Object)this.strategyClass().getSimpleName());
        ResponseCookieStrategy strategy = (ResponseCookieStrategy)this.loadCurrentStrategy(loginContext);
        if (strategy == null || !strategy.isEnabled()) {
            log.debug("execute {}Filter.strategy disabled, do nothing", (Object)this.strategyClass().getSimpleName());
            return;
        }
        String domain = StringUtils.defaultString((String)strategy.getDomain(), (String)loginContext.getHost());
        int maxAge = strategy.getMaxAge() != null && strategy.getMaxAge() > 0 ? strategy.getMaxAge() : 10;
        Duration duration = Duration.ofHours(maxAge);
        if (StringUtils.isNotBlank((CharSequence)domain)) {
            HashSet<ResponseCookie> responseCookies = new HashSet<ResponseCookie>();
            if (StringUtils.isNotBlank((CharSequence)loginContext.getToken())) {
                responseCookies.add(CookieUtils.buildCookie(UserType.USER.tokenKey(), loginContext.getToken(), duration, domain, strategy.isTopDomain()));
            }
            User user = loginContext.getUser();
            responseCookies.add(CookieUtils.buildCookie("userId", String.valueOf(user.getId()), duration, domain, strategy.isTopDomain()));
            if (StringUtils.isNotBlank((CharSequence)user.getUsername())) {
                responseCookies.add(CookieUtils.buildCookie(UserType.USER.usernameKey(), UriUtils.encode((String)user.getUsername(), (Charset)StandardCharsets.UTF_8), duration, domain, strategy.isTopDomain()));
                responseCookies.add(CookieUtils.buildCookie("userName", UriUtils.encode((String)user.getUsername(), (Charset)StandardCharsets.UTF_8), duration, domain, strategy.isTopDomain()));
            } else {
                responseCookies.add(CookieUtils.buildCookie("userName", UriUtils.encode((String)" ", (Charset)StandardCharsets.UTF_8), duration, domain, strategy.isTopDomain()));
            }
            loginContext.setCookies(responseCookies);
        }
    }

    protected ResponseCookieStrategyFilter(ResponseCookieStrategyFilterBuilder<?, ?> b) {
        super(b);
    }

    public static ResponseCookieStrategyFilterBuilder<?, ?> builder() {
        return new ResponseCookieStrategyFilterBuilderImpl();
    }

    private static final class ResponseCookieStrategyFilterBuilderImpl
    extends ResponseCookieStrategyFilterBuilder<ResponseCookieStrategyFilter, ResponseCookieStrategyFilterBuilderImpl> {
        private ResponseCookieStrategyFilterBuilderImpl() {
        }

        @Override
        protected ResponseCookieStrategyFilterBuilderImpl self() {
            return this;
        }

        @Override
        public ResponseCookieStrategyFilter build() {
            return new ResponseCookieStrategyFilter(this);
        }
    }

    public static abstract class ResponseCookieStrategyFilterBuilder<C extends ResponseCookieStrategyFilter, B extends ResponseCookieStrategyFilterBuilder<C, B>>
    extends AbstractStrategyFilter.AbstractStrategyFilterBuilder<ResponseCookieStrategy, C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "ResponseCookieStrategyFilter.ResponseCookieStrategyFilterBuilder(super=" + super.toString() + ")";
        }
    }
}

