/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.security.strategy.filter.impl;

import com.xforceplus.api.model.AccountModel;
import com.xforceplus.business.tenant.service.UserService;
import com.xforceplus.entity.Account;
import com.xforceplus.entity.User;
import com.xforceplus.security.login.context.LoginContext;
import com.xforceplus.security.login.exception.AuthenticationException;
import com.xforceplus.security.login.request.LoginRequest;
import com.xforceplus.security.login.request.TwoFactorPasswordLoginRequest;
import com.xforceplus.security.strategy.filter.AbstractStrategyFilter;
import com.xforceplus.security.strategy.filter.LoadUserFilter;
import com.xforceplus.security.strategy.model.TwoFactorStrategy;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

public class TwoFactorPasswordLoadUserStrategyFilter
extends AbstractStrategyFilter<TwoFactorStrategy>
implements LoadUserFilter<TwoFactorStrategy> {
    private static final Logger log = LoggerFactory.getLogger(TwoFactorPasswordLoadUserStrategyFilter.class);
    private static final String TWO_FACTOR_PWD_PREFIX = "TWO_FACTOR_PWD_";

    @Override
    public TwoFactorStrategy defaultStrategy() {
        return new TwoFactorStrategy();
    }

    @Override
    public boolean support(LoginContext<? extends LoginRequest> loginContext) {
        log.debug("execute {}Filter.support", (Object)this.strategyClass().getSimpleName());
        if (!LoadUserFilter.super.support(loginContext)) {
            return false;
        }
        if (loginContext.getLoginRequest() == null) {
            log.debug("execute {}Filter.loginContext.loginRequest = null, do nothing", (Object)this.strategyClass().getSimpleName());
            return false;
        }
        if (!(loginContext.getLoginRequest() instanceof TwoFactorPasswordLoginRequest)) {
            log.debug("execute {}Filter.loginContext.loginRequest not instanceof TwoFactorPasswordLoginRequest, do nothing", (Object)this.strategyClass().getSimpleName());
            return false;
        }
        return true;
    }

    @Override
    public void executeLoadUser(LoginContext<? extends LoginRequest> loginContext) {
        log.debug("execute {}Filter.executeLoadUser", (Object)this.strategyClass().getSimpleName());
        TwoFactorPasswordLoginRequest request = (TwoFactorPasswordLoginRequest)loginContext.getLoginRequest();
        if (StringUtils.isBlank((CharSequence)request.getPassword())) {
            throw new AuthenticationException(0, "\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String processId = request.getProcessId();
        String redisKey = TWO_FACTOR_PWD_PREFIX + processId;
        StringRedisTemplate redisTemplate = (StringRedisTemplate)this.applicationContext.getBean(StringRedisTemplate.class);
        String username = (String)redisTemplate.opsForValue().get((Object)redisKey);
        if (StringUtils.isBlank((CharSequence)username)) {
            throw new AuthenticationException(0, "\u8bf7\u5148\u8fdb\u884c\u624b\u673a\u53f7\u767b\u5f55\u9a8c\u8bc1\uff01");
        }
        if (loginContext.getLoginName() == null) {
            loginContext.setLoginName(username);
        }
        AccountModel.Request.Login login = new AccountModel.Request.Login();
        login.setUsername(loginContext.getLoginName());
        User user = loginContext.getUser();
        if (user == null) {
            UserService userService = (UserService)this.applicationContext.getBean(UserService.class);
            user = userService.findByUsername(username, 0);
        }
        if (user == null) {
            throw new AuthenticationException(0, "\u624b\u673a\u6216\u8005\u90ae\u7bb1\u6709\u8bef\uff0c\u65e0\u6cd5\u767b\u5f55\u3002");
        }
        loginContext.setTenantIds(user.getTenantIds());
        loginContext.setCurrentTenantId(user.getTenantId());
        TwoFactorStrategy strategy = (TwoFactorStrategy)this.loadCurrentStrategy(loginContext);
        log.debug("strategy: {}", (Object)strategy);
        Account account = user.getAccount();
        boolean enableTwoFactor = account.getDoubleAuthFlag() != null && account.getDoubleAuthFlag() != false;
        log.debug("enableTwoFactor = {}", (Object)enableTwoFactor);
        if (!(strategy != null && strategy.isEnabled() || enableTwoFactor)) {
            log.info("execute {}Filter.strategy disabled, do nothing", (Object)this.strategyClass().getSimpleName());
            throw new AuthenticationException(0, "\u79df\u6237\u7b56\u7565\u65e0\u9700\u53cc\u56e0\u5b50\u8ba4\u8bc1");
        }
        loginContext.setUser(user);
        loginContext.setAccount(account);
        Long tenantId = user.getTenantId();
        loginContext.setCurrentTenantId(tenantId);
        Long accountId = user.getAccountId();
        loginContext.setAccountId(accountId);
    }

    protected TwoFactorPasswordLoadUserStrategyFilter(TwoFactorPasswordLoadUserStrategyFilterBuilder<?, ?> b) {
        super(b);
    }

    public static TwoFactorPasswordLoadUserStrategyFilterBuilder<?, ?> builder() {
        return new TwoFactorPasswordLoadUserStrategyFilterBuilderImpl();
    }

    private static final class TwoFactorPasswordLoadUserStrategyFilterBuilderImpl
    extends TwoFactorPasswordLoadUserStrategyFilterBuilder<TwoFactorPasswordLoadUserStrategyFilter, TwoFactorPasswordLoadUserStrategyFilterBuilderImpl> {
        private TwoFactorPasswordLoadUserStrategyFilterBuilderImpl() {
        }

        @Override
        protected TwoFactorPasswordLoadUserStrategyFilterBuilderImpl self() {
            return this;
        }

        @Override
        public TwoFactorPasswordLoadUserStrategyFilter build() {
            return new TwoFactorPasswordLoadUserStrategyFilter(this);
        }
    }

    public static abstract class TwoFactorPasswordLoadUserStrategyFilterBuilder<C extends TwoFactorPasswordLoadUserStrategyFilter, B extends TwoFactorPasswordLoadUserStrategyFilterBuilder<C, B>>
    extends AbstractStrategyFilter.AbstractStrategyFilterBuilder<TwoFactorStrategy, C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "TwoFactorPasswordLoadUserStrategyFilter.TwoFactorPasswordLoadUserStrategyFilterBuilder(super=" + super.toString() + ")";
        }
    }
}

