/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.security.strategy.filter.impl;

import com.xforceplus.business.tenant.service.UserService;
import com.xforceplus.entity.Account;
import com.xforceplus.entity.User;
import com.xforceplus.security.login.context.LoginContext;
import com.xforceplus.security.login.exception.AuthenticationException;
import com.xforceplus.security.login.request.LoginRequest;
import com.xforceplus.security.login.request.TwoFactorSmsLoginRequest;
import com.xforceplus.security.strategy.filter.AbstractStrategyFilter;
import com.xforceplus.security.strategy.filter.LoadUserFilter;
import com.xforceplus.security.strategy.model.TwoFactorStrategy;
import com.xforceplus.utils.RegExUtil;
import com.xforececlound.message.api.EmailAuthCodeApi;
import com.xforececlound.message.api.SmsAuthCodeApi;
import com.xforececlound.message.model.EmailValidateReq;
import com.xforececlound.message.model.SmsValidateReq;
import com.xforececlound.message.model.SmsValidateResp;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

public class TwoFactorSmsLoadUserStrategyFilter
extends AbstractStrategyFilter<TwoFactorStrategy>
implements LoadUserFilter<TwoFactorStrategy> {
    private static final Logger log = LoggerFactory.getLogger(TwoFactorSmsLoadUserStrategyFilter.class);
    private static final String TWO_FACTOR_PWD_PREFIX = "TWO_FACTOR_PWD_";
    private static final String TWO_FACTOR_CODE_PREFIX = "TWO_FACTOR_CODE_";

    @Override
    public TwoFactorStrategy defaultStrategy() {
        return new TwoFactorStrategy();
    }

    @Override
    public boolean support(LoginContext<? extends LoginRequest> loginContext) {
        log.debug("execute {}Filter.support", (Object)this.strategyClass().getSimpleName());
        if (!LoadUserFilter.super.support(loginContext)) {
            return false;
        }
        LoginRequest loginRequest = loginContext.getLoginRequest();
        if (loginRequest == null) {
            log.debug("{}Filter.loginContext.loginRequest = null, do nothing", (Object)this.strategyClass().getSimpleName());
            return false;
        }
        if (!(loginRequest instanceof TwoFactorSmsLoginRequest)) {
            log.debug("{}Filter.loginContext.loginRequest not instanceof TwoFactorSmsLoginRequest, do nothing", (Object)this.strategyClass().getSimpleName());
            return false;
        }
        return true;
    }

    @Override
    public void executeLoadUser(LoginContext<? extends LoginRequest> loginContext) {
        boolean checked;
        block10: {
            log.debug("execute {}Filter.executeLoadUser", (Object)this.strategyClass().getSimpleName());
            TwoFactorSmsLoginRequest request = (TwoFactorSmsLoginRequest)loginContext.getLoginRequest();
            String processId = request.getProcessId();
            String key = TWO_FACTOR_CODE_PREFIX + processId;
            StringRedisTemplate redisTemplate = (StringRedisTemplate)this.applicationContext.getBean(StringRedisTemplate.class);
            String username = (String)redisTemplate.opsForValue().get((Object)key);
            if (StringUtils.isBlank((CharSequence)username)) {
                throw new AuthenticationException(0, "\u8bf7\u5148\u8fdb\u884c\u7528\u6237\u540d\u5bc6\u7801\u767b\u5f55\uff01");
            }
            if (StringUtils.isBlank((CharSequence)request.getMsgId()) || StringUtils.isBlank((CharSequence)request.getCipher())) {
                throw new AuthenticationException(0, "\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
            }
            User user = loginContext.getUser();
            if (user == null) {
                UserService userService = (UserService)this.applicationContext.getBean(UserService.class);
                user = userService.findByUsername(username, 0);
            }
            if (user == null) {
                throw new AuthenticationException(0, "\u624b\u673a\u6216\u8005\u90ae\u7bb1\u6709\u8bef\uff0c\u65e0\u6cd5\u767b\u5f55\u3002");
            }
            loginContext.setUser(user);
            Account account = user.getAccount();
            loginContext.setAccount(account);
            loginContext.setTenantIds(user.getTenantIds());
            Long tenantId = user.getTenantId();
            loginContext.setCurrentTenantId(tenantId);
            TwoFactorStrategy strategy = (TwoFactorStrategy)this.loadCurrentStrategy(loginContext);
            boolean enableTwoFactor = account.getDoubleAuthFlag() != null && account.getDoubleAuthFlag() != false;
            log.debug("enableTwoFactor = {}", (Object)enableTwoFactor);
            if (!(strategy != null && strategy.isEnabled() || enableTwoFactor)) {
                log.info("execute {}Filter.strategy disabled, do nothing", (Object)this.strategyClass().getSimpleName());
                throw new AuthenticationException(0, "\u79df\u6237\u7b56\u7565\u65e0\u9700\u53cc\u56e0\u5b50\u8ba4\u8bc1");
            }
            Long accountId = user.getAccountId();
            loginContext.setAccountId(accountId);
            try {
                if (RegExUtil.checkMobile((String)username)) {
                    SmsValidateReq smsValidateReq = new SmsValidateReq();
                    smsValidateReq.setMobile(username);
                    smsValidateReq.setCode(request.getCipher());
                    smsValidateReq.setMsgId(request.getMsgId());
                    SmsAuthCodeApi smsAuthCodeApi = (SmsAuthCodeApi)this.applicationContext.getBean(SmsAuthCodeApi.class);
                    SmsValidateResp smsValidateResp = smsAuthCodeApi.validate(String.valueOf(user.getTenantId()), smsValidateReq);
                    checked = smsValidateResp.isCheck();
                    break block10;
                }
                if (RegExUtil.checkEmail((String)username)) {
                    EmailValidateReq emailValidateReq = new EmailValidateReq();
                    emailValidateReq.setEmail(username);
                    emailValidateReq.setCode(request.getCipher());
                    emailValidateReq.setMsgId(request.getMsgId());
                    EmailAuthCodeApi emailAuthCodeApi = (EmailAuthCodeApi)this.applicationContext.getBean(EmailAuthCodeApi.class);
                    SmsValidateResp smsValidateResp = emailAuthCodeApi.validate(String.valueOf(user.getTenantId()), emailValidateReq);
                    checked = smsValidateResp.isCheck();
                    break block10;
                }
                throw new AuthenticationException(0, "\u8d26\u53f7\u5fc5\u987b\u4e3a\u624b\u673a\u6216\u8005\u90ae\u7bb1\uff01");
            }
            catch (Exception e) {
                log.error("valid.auth.code.error:{}", (Object)username, (Object)e);
                throw new AuthenticationException(0, "\u9a8c\u8bc1\u7801\u9a8c\u8bc1\u5f02\u5e38");
            }
        }
        if (!checked) {
            throw new AuthenticationException(0, "\u9a8c\u8bc1\u7801\u9a8c\u8bc1\u5931\u8d25");
        }
    }

    protected TwoFactorSmsLoadUserStrategyFilter(TwoFactorSmsLoadUserStrategyFilterBuilder<?, ?> b) {
        super(b);
    }

    public static TwoFactorSmsLoadUserStrategyFilterBuilder<?, ?> builder() {
        return new TwoFactorSmsLoadUserStrategyFilterBuilderImpl();
    }

    private static final class TwoFactorSmsLoadUserStrategyFilterBuilderImpl
    extends TwoFactorSmsLoadUserStrategyFilterBuilder<TwoFactorSmsLoadUserStrategyFilter, TwoFactorSmsLoadUserStrategyFilterBuilderImpl> {
        private TwoFactorSmsLoadUserStrategyFilterBuilderImpl() {
        }

        @Override
        protected TwoFactorSmsLoadUserStrategyFilterBuilderImpl self() {
            return this;
        }

        @Override
        public TwoFactorSmsLoadUserStrategyFilter build() {
            return new TwoFactorSmsLoadUserStrategyFilter(this);
        }
    }

    public static abstract class TwoFactorSmsLoadUserStrategyFilterBuilder<C extends TwoFactorSmsLoadUserStrategyFilter, B extends TwoFactorSmsLoadUserStrategyFilterBuilder<C, B>>
    extends AbstractStrategyFilter.AbstractStrategyFilterBuilder<TwoFactorStrategy, C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "TwoFactorSmsLoadUserStrategyFilter.TwoFactorSmsLoadUserStrategyFilterBuilder(super=" + super.toString() + ")";
        }
    }
}

