/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.security.strategy.filter.impl;

import com.xforceplus.entity.Account;
import com.xforceplus.security.login.context.LoginContext;
import com.xforceplus.security.login.exception.AuthenticationException;
import com.xforceplus.security.login.request.LoginRequest;
import com.xforceplus.security.login.request.PasswordLoginRequest;
import com.xforceplus.security.login.request.SmsLoginRequest;
import com.xforceplus.security.login.response.LoginFailResponse;
import com.xforceplus.security.login.response.LoginTokenResponse;
import com.xforceplus.security.strategy.filter.AbstractStrategyFilter;
import com.xforceplus.security.strategy.filter.PostLoadValidationFilter;
import com.xforceplus.security.strategy.model.TwoFactorStrategy;
import com.xforceplus.security.strategy.model.TwoFactorType;
import io.geewit.utils.uuid.UUIDUtils;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;

public class TwoFactorValidStrategyFilter
extends AbstractStrategyFilter<TwoFactorStrategy>
implements PostLoadValidationFilter<TwoFactorStrategy> {
    private static final Logger log = LoggerFactory.getLogger(TwoFactorValidStrategyFilter.class);
    private static final String TWO_FACTOR_PWD_PREFIX = "TWO_FACTOR_PWD_";
    private static final String TWO_FACTOR_CODE_PREFIX = "TWO_FACTOR_CODE_";

    @Override
    public TwoFactorStrategy defaultStrategy() {
        return new TwoFactorStrategy();
    }

    @Override
    public boolean support(LoginContext<? extends LoginRequest> loginContext) {
        log.debug("execute {}Filter.support", (Object)this.strategyClass().getSimpleName());
        if (!PostLoadValidationFilter.super.support(loginContext)) {
            return false;
        }
        if (loginContext.getLoginRequest() == null) {
            log.debug("this {}Filter.loginContext.loginRequest = null, do nothing", (Object)this.strategyClass().getSimpleName());
            return false;
        }
        if (!(loginContext.getLoginRequest() instanceof PasswordLoginRequest) && !(loginContext.getLoginRequest() instanceof SmsLoginRequest)) {
            log.debug("this {}Filter.loginContext.loginRequest not instanceof PasswordLoginRequest and not instanceof SmsLoginRequest, do nothing", (Object)this.strategyClass().getSimpleName());
            return false;
        }
        return true;
    }

    @Override
    public void executePostLoadValid(LoginContext<? extends LoginRequest> loginContext) {
        LoginTokenResponse response;
        log.debug("execute {}Filter.executePostLoadValid", (Object)this.strategyClass().getSimpleName());
        Account account = loginContext.getAccount();
        boolean enableTwoFactor = account.getDoubleAuthFlag() != null && account.getDoubleAuthFlag() != false;
        TwoFactorStrategy strategy = (TwoFactorStrategy)this.loadCurrentStrategy(loginContext);
        enableTwoFactor = enableTwoFactor || strategy.isEnabled();
        log.debug("execute {}Filter.enableTwoFactor = {}", (Object)this.strategyClass().getSimpleName(), (Object)enableTwoFactor);
        if (!enableTwoFactor) {
            return;
        }
        StringRedisTemplate redisTemplate = (StringRedisTemplate)this.applicationContext.getBean(StringRedisTemplate.class);
        if (loginContext.getLoginRequest() instanceof PasswordLoginRequest) {
            log.debug("{}Filter.loginContext.loginRequest not instanceof PasswordLoginRequest, do nothing", (Object)this.strategyClass().getSimpleName());
            String senderKey = null;
            if (TwoFactorType.MOBILE.equals((Object)strategy.getPerferType())) {
                if (!StringUtils.isBlank((CharSequence)account.getTelPhone())) {
                    senderKey = account.getTelPhone();
                } else if (!StringUtils.isBlank((CharSequence)account.getEmail())) {
                    senderKey = account.getEmail();
                }
            } else if (!StringUtils.isBlank((CharSequence)account.getEmail())) {
                senderKey = account.getEmail();
            } else if (!StringUtils.isBlank((CharSequence)account.getTelPhone())) {
                senderKey = account.getTelPhone();
            }
            if (senderKey != null) {
                String processId = UUIDUtils.randomUUID();
                String key = TWO_FACTOR_CODE_PREFIX + processId;
                int timeout = strategy.getTimeout() != null && strategy.getTimeout() > 0 ? strategy.getTimeout() : 5;
                redisTemplate.opsForValue().set((Object)key, (Object)senderKey, (long)timeout, TimeUnit.MINUTES);
                LoginFailResponse response2 = LoginFailResponse.builder().username(senderKey).processId(processId).build();
                throw new AuthenticationException(8, "\u4e8c\u6b21\u8ba4\u8bc1\u624b\u673a\u53f7/\u6216\u90ae\u7bb1", response2);
            }
        } else if (loginContext.getLoginRequest() instanceof SmsLoginRequest) {
            log.debug("{}Filter.loginContext.loginRequest instanceof SmsLoginRequest", (Object)this.strategyClass().getSimpleName());
            String processId = UUIDUtils.randomUUID();
            String key = TWO_FACTOR_PWD_PREFIX + processId;
            SmsLoginRequest loginRequest = (SmsLoginRequest)loginContext.getLoginRequest();
            int timeout = strategy.getTimeout() != null && strategy.getTimeout() > 0 ? strategy.getTimeout() : 5;
            redisTemplate.opsForValue().set((Object)key, (Object)loginRequest.getPhone(), (long)timeout, TimeUnit.MINUTES);
            throw new AuthenticationException(9, "\u4e8c\u6b21\u8ba4\u8bc1\u5bc6\u7801", LoginFailResponse.builder().processId(processId).build());
        }
        if ((response = loginContext.getResponse()) == null) {
            response = LoginTokenResponse.builder().build();
            loginContext.setResponse(response);
        }
        response.setDoubleAuthFlag(true);
    }

    protected TwoFactorValidStrategyFilter(TwoFactorValidStrategyFilterBuilder<?, ?> b) {
        super(b);
    }

    public static TwoFactorValidStrategyFilterBuilder<?, ?> builder() {
        return new TwoFactorValidStrategyFilterBuilderImpl();
    }

    private static final class TwoFactorValidStrategyFilterBuilderImpl
    extends TwoFactorValidStrategyFilterBuilder<TwoFactorValidStrategyFilter, TwoFactorValidStrategyFilterBuilderImpl> {
        private TwoFactorValidStrategyFilterBuilderImpl() {
        }

        @Override
        protected TwoFactorValidStrategyFilterBuilderImpl self() {
            return this;
        }

        @Override
        public TwoFactorValidStrategyFilter build() {
            return new TwoFactorValidStrategyFilter(this);
        }
    }

    public static abstract class TwoFactorValidStrategyFilterBuilder<C extends TwoFactorValidStrategyFilter, B extends TwoFactorValidStrategyFilterBuilder<C, B>>
    extends AbstractStrategyFilter.AbstractStrategyFilterBuilder<TwoFactorStrategy, C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "TwoFactorValidStrategyFilter.TwoFactorValidStrategyFilterBuilder(super=" + super.toString() + ")";
        }
    }
}

