/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.security.strategy.filter.impl;

import com.google.common.eventbus.Subscribe;
import com.xforceplus.api.model.LoginLogModel;
import com.xforceplus.business.account.service.LoginLogService;
import com.xforceplus.security.login.context.LoginContext;
import com.xforceplus.security.login.request.LoginRequest;
import com.xforceplus.security.strategy.filter.AbstractStrategyFilter;
import com.xforceplus.security.strategy.filter.PostLoginSuccessFilter;
import com.xforceplus.security.strategy.model.UpdateLoginTimeStrategy;
import java.util.Calendar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateLoginTimeStrategyFilter
extends AbstractStrategyFilter<UpdateLoginTimeStrategy>
implements PostLoginSuccessFilter<UpdateLoginTimeStrategy> {
    private static final Logger log = LoggerFactory.getLogger(UpdateLoginTimeStrategyFilter.class);

    public void init() {
        ASYNC_EVENT_BUS.register((Object)this);
    }

    @Override
    public UpdateLoginTimeStrategy defaultStrategy() {
        return new UpdateLoginTimeStrategy();
    }

    @Override
    public boolean support(LoginContext<? extends LoginRequest> loginContext) {
        log.debug("execute {}Filter.support", (Object)this.strategyClass().getSimpleName());
        if (!PostLoginSuccessFilter.super.support(loginContext)) {
            return false;
        }
        if (loginContext.getAccountId() == null) {
            log.debug("{}Filter.loginContext.accountId = null, do nothing", (Object)this.strategyClass().getSimpleName());
            return false;
        }
        if (loginContext.getUser() == null) {
            log.debug("{}Filter.loginContext.user = null, do nothing", (Object)this.strategyClass().getSimpleName());
            return false;
        }
        if (loginContext.getLoginName() == null) {
            log.debug("{}Filter.loginContext.loginName = null, do nothing", (Object)this.strategyClass().getSimpleName());
            return false;
        }
        return true;
    }

    @Override
    public void executePostLoginSuccess(LoginContext<? extends LoginRequest> loginContext) {
        log.debug("execute {}Filter.executePostLoginSuccess", (Object)this.strategyClass().getSimpleName());
        if (loginContext == null || !loginContext.getSuccess().booleanValue()) {
            log.debug("this {}Filter.loginContext.isSuccess = false, do nothing", (Object)this.strategyClass().getSimpleName());
            return;
        }
        UpdateLoginTimeStrategy strategy = (UpdateLoginTimeStrategy)this.loadCurrentStrategy(loginContext);
        if (strategy == null || !strategy.isEnabled()) {
            log.debug("execute {}Filter.strategy disabled, do nothing", (Object)this.strategyClass().getSimpleName());
            return;
        }
        LoginLogModel.Request.Save save = new LoginLogModel.Request.Save();
        Long accountId = loginContext.getAccountId();
        Long userId = loginContext.getUser().getId();
        save.setAccountId(accountId);
        save.setUserId(userId);
        save.setLoginName(loginContext.getLoginName());
        save.setLoginTime(Calendar.getInstance().getTime());
        ASYNC_EVENT_BUS.post((Object)save);
    }

    @Subscribe
    public void doProcess(LoginLogModel.Request.Save save) {
        try {
            LoginLogService loginLogService = (LoginLogService)this.applicationContext.getBean(LoginLogService.class);
            loginLogService.create(save);
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
    }

    protected UpdateLoginTimeStrategyFilter(UpdateLoginTimeStrategyFilterBuilder<?, ?> b) {
        super(b);
    }

    public static UpdateLoginTimeStrategyFilterBuilder<?, ?> builder() {
        return new UpdateLoginTimeStrategyFilterBuilderImpl();
    }

    private static final class UpdateLoginTimeStrategyFilterBuilderImpl
    extends UpdateLoginTimeStrategyFilterBuilder<UpdateLoginTimeStrategyFilter, UpdateLoginTimeStrategyFilterBuilderImpl> {
        private UpdateLoginTimeStrategyFilterBuilderImpl() {
        }

        @Override
        protected UpdateLoginTimeStrategyFilterBuilderImpl self() {
            return this;
        }

        @Override
        public UpdateLoginTimeStrategyFilter build() {
            return new UpdateLoginTimeStrategyFilter(this);
        }
    }

    public static abstract class UpdateLoginTimeStrategyFilterBuilder<C extends UpdateLoginTimeStrategyFilter, B extends UpdateLoginTimeStrategyFilterBuilder<C, B>>
    extends AbstractStrategyFilter.AbstractStrategyFilterBuilder<UpdateLoginTimeStrategy, C, B> {
        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "UpdateLoginTimeStrategyFilter.UpdateLoginTimeStrategyFilterBuilder(super=" + super.toString() + ")";
        }
    }
}

