/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.security.strategy.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.xforceplus.security.strategy.model.Strategy;
import io.swagger.annotations.ApiModelProperty;
import java.util.Calendar;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AccountLoginFailStrategy
implements Strategy,
Comparable<AccountLoginFailStrategy> {
    public static final String ACCOUNT_LOGIN_FAILS_PREFIX = "ACCOUNT_LOGIN_FAILS_";
    public static final int DEFAULT_THRESHOLD = 10;
    public static final int DEFAULT_TIMEOUT = 30;
    @ApiModelProperty(value="\u9700\u8981\u9501\u5b9a\u8d26\u6237\u9519\u6b21\u9608\u503c", example="10")
    private Integer threshold = 10;
    @ApiModelProperty(value="\u9501\u5b9a\u8d26\u6237\u65f6\u957f (MINUTE)", example="30")
    private Integer timeout = 30;
    private boolean enabled = true;

    @Override
    public String getName() {
        return AccountLoginFailStrategy.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "\u5bc6\u7801\u767b\u5f55\u9519\u6b21\u6821\u9a8c\u5b89\u5168\u7b56\u7565";
    }

    @Override
    public int compareTo(@NotNull AccountLoginFailStrategy that) {
        return Integer.compare((Integer)ObjectUtils.defaultIfNull((Object)that.threshold, (Object)10), (Integer)ObjectUtils.defaultIfNull((Object)this.threshold, (Object)10));
    }

    public static String lockMessage(int expireMinutes) {
        Calendar expiredCalender = Calendar.getInstance();
        expiredCalender.add(12, expireMinutes);
        String message = String.format("\u7528\u6237\u540d/\u5bc6\u7801\u9519\u8bef\uff0c\u8d26\u6237\u5df2\u9501\u5b9a\uff0c\u8bf7\u4e8e%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS\u540e\u518d\u8bd5", expiredCalender);
        return message;
    }

    public String toString() {
        return "AccountLoginFailStrategy(threshold=" + this.getThreshold() + ", timeout=" + this.getTimeout() + ", enabled=" + this.isEnabled() + ")";
    }

    public void setThreshold(Integer threshold) {
        this.threshold = threshold;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Integer getThreshold() {
        return this.threshold;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }
}

