/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.security.strategy.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.xforceplus.security.strategy.model.Strategy;
import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PasswordPatternStrategy
implements Strategy,
Comparable<PasswordPatternStrategy> {
    public static final Map<String, Pair<Integer, Pattern>> PATTERN_MAP = new ConcurrentHashMap<String, Pair<Integer, Pattern>>();
    @ApiModelProperty(value="\u6700\u8fd1\u4f7f\u7528\u8fc7\u7684\u5bc6\u7801\u4fdd\u5b58\u6761\u6570", example="\u5bc6\u7801\u683c\u5f0f\u4e3a8\u523016\u4f4d\uff0c\u82f1\u6587+\u6570\u5b57\u7ec4\u5408")
    private String pattern = "\u5bc6\u7801\u683c\u5f0f\u4e3a8\u523016\u4f4d\uff0c\u82f1\u6587+\u6570\u5b57\u7ec4\u5408";

    @Override
    public String getName() {
        return PasswordPatternStrategy.class.getSimpleName();
    }

    @Override
    public String getDescription() {
        return "\u5bc6\u7801\u683c\u5f0f\u5b89\u5168\u7b56\u7565";
    }

    public static Pattern findPattern(String patternValue) {
        Pattern pattern;
        Pair pair = PATTERN_MAP.get(patternValue);
        if (pair == null) {
            try {
                pattern = Pattern.compile(patternValue);
                pair = Pair.of((Object)PATTERN_MAP.size(), (Object)pattern);
                PATTERN_MAP.put(patternValue, (Pair<Integer, Pattern>)pair);
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException("\u975e\u6cd5\u7684\u6b63\u5219\u8868\u8fbe\u5f0f");
            }
        } else {
            pattern = (Pattern)pair.getValue();
        }
        return pattern;
    }

    public String getMessage() {
        return "\u5bc6\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c" + this.pattern + "\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002";
    }

    @JsonIgnore
    public int minLength() {
        int lastMinLength;
        Pattern pattern = PasswordPatternStrategy.findPattern(this.pattern);
        if (pattern == null) {
            return 0;
        }
        String patternValue = pattern.pattern();
        String lastMinLengthValue = StringUtils.substringAfterLast((String)patternValue, (String)"{");
        lastMinLengthValue = StringUtils.substringBefore((String)lastMinLengthValue, (String)",");
        try {
            lastMinLength = Integer.parseInt(lastMinLengthValue);
        }
        catch (NumberFormatException e) {
            lastMinLength = 0;
        }
        return lastMinLength;
    }

    @Override
    public int compareTo(@NotNull PasswordPatternStrategy strategy) {
        Pair<Integer, Pattern> thisPair = PATTERN_MAP.get(this.pattern);
        Integer thisIndex = thisPair != null ? (Integer)thisPair.getKey() : Integer.valueOf(Integer.MAX_VALUE);
        Pair<Integer, Pattern> thatPair = PATTERN_MAP.get(strategy.pattern);
        Integer thatIndex = thatPair != null ? (Integer)thatPair.getKey() : Integer.valueOf(Integer.MAX_VALUE);
        return Integer.compare(thisIndex, thatIndex);
    }

    public String toString() {
        return "PasswordPatternStrategy(pattern=" + this.getPattern() + ")";
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    static {
        PATTERN_MAP.put("\u5bc6\u7801\u683c\u5f0f\u4e3a8\u523016\u4f4d\uff0c\u82f1\u6587+\u6570\u5b57\u7ec4\u5408", (Pair<Integer, Pattern>)Pair.of((Object)1, (Object)Pattern.compile("^(?=.*[0-9])(?=.*[A-z])[0-9A-z!?@#$%^&*_-]{8,16}$")));
        PATTERN_MAP.put("\u5bc6\u7801\u683c\u5f0f\u4e3a12\u523016\u4f4d\uff0c\u82f1\u6587+\u6570\u5b57\u7ec4\u5408", (Pair<Integer, Pattern>)Pair.of((Object)2, (Object)Pattern.compile("^(?=.*[0-9])(?=.*[A-z])[0-9A-z!?@#$%^&*_-]{12,16}$")));
        PATTERN_MAP.put("\u5bc6\u7801\u683c\u5f0f\u4e3a8\u523016\u4f4d\uff0c\u82f1\u6587+\u6570\u5b57+\u7b26\u53f7\u7ec4\u5408", (Pair<Integer, Pattern>)Pair.of((Object)3, (Object)Pattern.compile("^(?![0-9!?@#$%^&*_-]+$)(?![A-z!?@#$%^&*_-]+$)(?![0-9A-z]+$)[0-9A-z!?@#$%^&*_-]{8,16}$")));
        PATTERN_MAP.put("\u5bc6\u7801\u683c\u5f0f\u4e3a12\u523016\u4f4d\uff0c\u82f1\u6587+\u6570\u5b57+\u7b26\u53f7\u7ec4\u5408", (Pair<Integer, Pattern>)Pair.of((Object)4, (Object)Pattern.compile("^(?![0-9!?@#$%^&*_-]+$)(?![A-z!?@#$%^&*_-]+$)(?![0-9A-z]+$)[0-9A-z!?@#$%^&*_-]{12,16}$")));
    }
}

