/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.security.strategy.service;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.xforceplus.dao.TenantPolicyDao;
import com.xforceplus.entity.TenantPolicy;
import com.xforceplus.event.publisher.MessagePublisher;
import com.xforceplus.security.login.context.LoginContext;
import com.xforceplus.security.login.request.LoginRequest;
import com.xforceplus.security.strategy.model.AccountLoginFailStrategy;
import com.xforceplus.security.strategy.model.CaptchaStrategy;
import com.xforceplus.security.strategy.model.GenerateTokenStrategy;
import com.xforceplus.security.strategy.model.LoadUserByPasswordStrategy;
import com.xforceplus.security.strategy.model.LoadUserBySmsStrategy;
import com.xforceplus.security.strategy.model.NewAccountStrategy;
import com.xforceplus.security.strategy.model.PasswordExpiredStrategy;
import com.xforceplus.security.strategy.model.PasswordPatternStrategy;
import com.xforceplus.security.strategy.model.PasswordRepetitionStrategy;
import com.xforceplus.security.strategy.model.PostLoadUserStrategy;
import com.xforceplus.security.strategy.model.ResponseCookieStrategy;
import com.xforceplus.security.strategy.model.Strategy;
import com.xforceplus.security.strategy.model.TwoFactorStrategy;
import com.xforceplus.security.strategy.model.UpdateLoginTimeStrategy;
import io.geewit.utils.uuid.UUIDUtils;
import io.geewit.web.utils.JsonUtils;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class StrategyService {
    private static final Logger log = LoggerFactory.getLogger(StrategyService.class);
    private final MessagePublisher messagePublisher;
    private final TenantPolicyDao tenantPolicyDao;
    private final LoadingCache<Class<? extends Strategy>, Map<Long, ? extends Strategy>> strategyCache;

    public StrategyService(@Qualifier(value="refreshingStrategyRedisPublisher") MessagePublisher messagePublisher, TenantPolicyDao tenantPolicyDao, Environment environment) {
        this.messagePublisher = messagePublisher;
        this.tenantPolicyDao = tenantPolicyDao;
        this.strategyCache = CacheBuilder.newBuilder().expireAfterWrite(Duration.of((Long)environment.getProperty("xforce.tenant.strategy.cache.time-live-minutes", Long.class, (Object)3L), ChronoUnit.MINUTES)).build((CacheLoader)new CacheLoader<Class<? extends Strategy>, Map<Long, ? extends Strategy>>(){

            public Map<Long, ? extends Strategy> load(Class<? extends Strategy> clazz) {
                return StrategyService.this.loadStrategyMapFromDb(clazz);
            }
        });
    }

    public <S extends Strategy> S loadStrategy(Long tenantId, Class<S> clazz) {
        log.debug("StrategyService loadStrategy");
        tenantId = (Long)ObjectUtils.defaultIfNull((Object)tenantId, (Object)0L);
        Map tenantStrategyMap = (Map)this.strategyCache.getUnchecked(clazz);
        Strategy strategy = (Strategy)tenantStrategyMap.get(tenantId);
        return (S)strategy;
    }

    public <S extends Strategy> Map<Long, S> loadStrategiesMap(LoginContext<? extends LoginRequest> loginContext, Class<S> clazz) {
        Set<Long> tenantIds = loginContext.getTenantIds();
        return this.loadStrategiesMap(tenantIds, clazz);
    }

    public <S extends Strategy> Map<Long, S> loadStrategiesMap(Set<Long> tenantIds, Class<S> clazz) {
        if (tenantIds == null || tenantIds.isEmpty()) {
            log.info("tenantIds == null || tenantIds.isEmpty, return null");
            return null;
        }
        Map tenantStrategyMap = (Map)this.strategyCache.getUnchecked(clazz);
        HashMap strategyMap = new HashMap();
        tenantIds.forEach(tenantId -> {
            Strategy strategy = (Strategy)tenantStrategyMap.get(tenantId);
            if (strategy != null) {
                strategyMap.put(tenantId, strategy);
            }
        });
        return strategyMap;
    }

    private <S extends Strategy> Map<Long, S> loadStrategyMapFromDb(Class<S> clazz) {
        log.debug("StrategyService loadStrategyMapFromDb");
        String strategyName = clazz.getSimpleName();
        List policies = this.tenantPolicyDao.findByName(strategyName);
        HashMap<Long, Strategy> tenantStrategyMap = new HashMap<Long, Strategy>();
        for (TenantPolicy tenantPolicy : policies) {
            Strategy strategy = null;
            if (tenantPolicy != null) {
                String policyValue = tenantPolicy.getPolicy();
                log.debug("policyValue = {}", (Object)policyValue);
                try {
                    strategy = (Strategy)JsonUtils.fromJson((String)policyValue, clazz);
                }
                catch (Exception e) {
                    log.warn("\u79df\u6237\u7b56\u7565\u914d\u7f6e\u6709\u8bef(id:{})", (Object)tenantPolicy.getId());
                }
            }
            if (strategy == null) continue;
            tenantStrategyMap.put(tenantPolicy.getTenantId(), strategy);
        }
        return tenantStrategyMap;
    }

    public List<? super Strategy> allStrategies() {
        ArrayList<Strategy> strategies = new ArrayList<Strategy>();
        strategies.add(new AccountLoginFailStrategy());
        strategies.add(new CaptchaStrategy());
        strategies.add(new GenerateTokenStrategy());
        strategies.add(new LoadUserByPasswordStrategy());
        strategies.add(new LoadUserBySmsStrategy());
        strategies.add(new NewAccountStrategy());
        strategies.add(new PasswordExpiredStrategy());
        strategies.add(new PasswordPatternStrategy());
        strategies.add(new PasswordRepetitionStrategy());
        strategies.add(new PostLoadUserStrategy());
        strategies.add(new ResponseCookieStrategy());
        strategies.add(new TwoFactorStrategy());
        strategies.add(new UpdateLoginTimeStrategy());
        return strategies;
    }

    public String refresh() {
        log.debug("execute refresh");
        String refreshId = UUIDUtils.randomUUID();
        this.messagePublisher.publish(refreshId);
        this.refreshCache();
        return refreshId;
    }

    public void refreshCache() {
        log.debug("execute refreshCache");
        this.strategyCache.invalidateAll();
    }
}

