/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.security.utils;

import com.google.common.net.InternetDomainName;
import java.time.Duration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseCookie;

public class CookieUtils {
    private static final Logger logger = LoggerFactory.getLogger(CookieUtils.class);

    public static ResponseCookie buildCookie(String key, String value, Duration duration, String domain, boolean isTopDomain) {
        ResponseCookie.ResponseCookieBuilder builder = ResponseCookie.from((String)key, (String)value).path("/");
        String[] hostAndPort = StringUtils.split((String)domain, (String)":");
        String host = hostAndPort.length == 1 ? domain : hostAndPort[0];
        if (isTopDomain) {
            try {
                host = InternetDomainName.from((String)host).topPrivateDomain().toString();
            }
            catch (Exception e) {
                logger.info(e.getMessage());
            }
        }
        ResponseCookie cookie = builder.maxAge(duration).domain(host).build();
        return cookie;
    }
}

