/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils;

import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tenant.security.token.domain.IRole;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Triple;
import org.springframework.util.CollectionUtils;

public class RoleUtils {
    public static Triple<Boolean, Set<Long>, Set<Long>> calcAdminAndGradingRoles(IAuthorizedUser authorizedUser) {
        Set roles = authorizedUser.getRoles();
        boolean isAdmin = false;
        Set gradingRoleIds = null;
        Set orgRoleIds = null;
        if (!CollectionUtils.isEmpty((Collection)roles)) {
            for (IRole role : roles) {
                if (role.getId() == null) continue;
                if (role.getId() == 1L) {
                    isAdmin = true;
                    break;
                }
                if (role.getType() == null) continue;
                if (role.getType() == 1) {
                    if (gradingRoleIds == null) {
                        gradingRoleIds = Stream.of(role.getId()).collect(Collectors.toSet());
                        continue;
                    }
                    gradingRoleIds.add(role.getId());
                    continue;
                }
                if (role.getType() != 2) continue;
                if (orgRoleIds == null) {
                    orgRoleIds = Stream.of(role.getId()).collect(Collectors.toSet());
                    continue;
                }
                orgRoleIds.add(role.getId());
            }
        }
        return Triple.of((Object)isAdmin, gradingRoleIds, orgRoleIds);
    }
}

