/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils.excel;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.analysis.ExcelReadExecutor;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.xforceplus.utils.excel.listener.ExcelConvertListener;
import com.xforceplus.utils.excel.model.ExcelToJsonProperty;
import com.xforceplus.utils.excel.model.JsonToExcelProperty;
import io.geewit.web.utils.JsonUtils;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class ExcelConvertUtil {
    private static Logger logger = LoggerFactory.getLogger(ExcelConvertUtil.class);

    public static String excelToJson(ExcelToJsonProperty property) {
        ExcelConvertUtil.checkProperties(property);
        MultipartFile file = property.getFile();
        String json = property.getJson().replaceAll("\\s+", "");
        Integer startRow = property.getStartRow();
        Integer startSheet = property.getStartSheet();
        InputStream inputStream = null;
        try {
            String inputJson;
            inputStream = file.getInputStream();
            String string = inputJson = ExcelConvertUtil.generateInputStreamToJson(inputStream, json, startRow, startSheet);
            return string;
        }
        catch (IOException e) {
            logger.error("excelToJson exception", (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error("excelToJson Io Exception ", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void jsonToExcel(List<JsonToExcelProperty> properties, String fileName) {
        ExcelConvertUtil.checkJsonToExcelProperty(properties, fileName);
        FileOutputStream out = null;
        ExcelWriter writer = null;
        try {
            out = new FileOutputStream(fileName);
            writer = EasyExcelFactory.getWriter((OutputStream)out);
            for (int i = 0; i < properties.size(); ++i) {
                JsonToExcelProperty property = properties.get(i);
                String sheetName = StringUtils.isEmpty((CharSequence)property.getSheetName()) ? "sheet" + i++ : property.getSheetName();
                String json = property.getJson();
                Map<String, String> rules = property.getRules();
                List<List<String>> headers = ExcelConvertUtil.createTestListStringHead(json, rules);
                WriteSheet writeSheet = EasyExcel.writerSheet((Integer)(i + 1), (String)sheetName).build();
                writeSheet.setHead(headers);
                List<List<Object>> datas = ExcelConvertUtil.createTestListObject(json, rules);
                writer.write(datas, writeSheet);
            }
        }
        catch (Exception var20) {
            logger.error("jsonToExcel error :", (Throwable)var20);
        }
        finally {
            if (writer != null) {
                writer.finish();
            }
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException var19) {
                    logger.error("outinputstream close error ", (Throwable)var19);
                }
            }
        }
    }

    private static String generateInputStreamToJson(InputStream inputStream, String json, Integer startRow, Integer startSheet) {
        ExcelConvertListener excelListener = new ExcelConvertListener();
        excelListener.setJson(json);
        ExcelReader excelReader = EasyExcelFactory.getReader((InputStream)inputStream, (AnalysisEventListener)excelListener);
        ExcelReadExecutor excelExecutor = excelReader.excelExecutor();
        List sheets = excelExecutor.sheetList();
        logger.info("all sheets {}", (Object)sheets);
        if (CollectionUtils.isEmpty((Collection)sheets)) {
            throw new IllegalArgumentException("current excel has no sheet,please import a right excel!");
        }
        ArrayList datas = Lists.newArrayList();
        for (int i = startSheet - 1; i < sheets.size(); ++i) {
            ReadSheet sheet = (ReadSheet)sheets.get(i);
            excelReader.read(new ReadSheet[]{sheet});
            List<Map> data = excelListener.getData();
            datas.addAll(data);
        }
        if (CollectionUtils.isEmpty((Collection)datas)) {
            throw new IllegalArgumentException("convert result is '[]' ,please check your file or request params is correct!");
        }
        return JSON.toJSONString((Object)datas);
    }

    private static List<List<Object>> createTestListObject(String json, Map<String, String> rules) {
        List maps = (List)JsonUtils.fromJson((String)json, (TypeReference)new TypeReference<List<Map<String, String>>>(){});
        ArrayList datas = Lists.newArrayList();
        for (Map map : maps) {
            ArrayList keys = new ArrayList(map.keySet());
            ArrayList<String> ruleKeys = new ArrayList<String>(rules.keySet());
            ArrayList values = Lists.newArrayList();
            keys.forEach(k -> {
                if (ruleKeys.contains(k)) {
                    String value = (String)map.get(k);
                    if (StringUtils.isEmpty((CharSequence)value)) {
                        value = "";
                    }
                    values.add(value);
                }
            });
            datas.add(values);
        }
        return datas;
    }

    private static List<List<String>> createTestListStringHead(String json, Map<String, String> rules) {
        List datas = JSONObject.parseArray((String)json, LinkedHashMap.class);
        Map map = (Map)datas.get(0);
        ArrayList headers = Lists.newArrayList();
        for (String key : map.keySet()) {
            ArrayList header = Lists.newArrayList();
            String chinessHeader = rules.get(key);
            if (StringUtils.isEmpty((CharSequence)chinessHeader)) continue;
            header.add(chinessHeader);
            headers.add(header);
        }
        return headers;
    }

    private static void checkJsonToExcelProperty(List<JsonToExcelProperty> propertys, String fileName) {
        String json;
        if (CollectionUtils.isEmpty(propertys)) {
            throw new IllegalArgumentException("properties can not be empty!");
        }
        Iterator<JsonToExcelProperty> iterator = propertys.iterator();
        do {
            if (!iterator.hasNext()) {
                Objects.requireNonNull(fileName, "fileName can not be null!");
                if (!fileName.endsWith(ExcelTypeEnum.XLS.getValue()) && !fileName.endsWith(ExcelTypeEnum.XLSX.getValue())) {
                    throw new IllegalArgumentException("excel must endwith .xls or .xlsx!");
                }
                return;
            }
            JsonToExcelProperty property = iterator.next();
            json = property.getJson();
            Map<String, String> rules = property.getRules();
            Objects.requireNonNull(rules, "rules can not be null!");
        } while (!StringUtils.isEmpty((CharSequence)json));
        throw new IllegalArgumentException("json can not be null!");
    }

    private static void checkProperties(ExcelToJsonProperty property) {
        MultipartFile file = property.getFile();
        String json = property.getJson();
        String filename = file.getOriginalFilename();
        Integer startRow = property.getStartRow();
        Integer startSheet = property.getStartSheet();
        Objects.requireNonNull(file, "file can not be null!");
        Objects.requireNonNull(filename, "fileName can not be null!");
        if (StringUtils.isEmpty((CharSequence)json)) {
            throw new IllegalArgumentException("the result json can not be null!");
        }
        if (!filename.endsWith(ExcelTypeEnum.XLS.getValue()) && !filename.endsWith(ExcelTypeEnum.XLSX.getValue())) {
            throw new IllegalArgumentException("excel must endwith .xls or .xlsx!");
        }
        if (startRow <= 0 || startSheet <= 0) {
            throw new IllegalArgumentException("\u5f00\u59cb\u7684\u884cstartRow \u6216\u8005 \u5f00\u59cb\u8bfb\u53d6\u7684sheet \u6700\u5c0f\u8981\u4ece 1 \u5f00\u59cb!");
        }
    }
}

