/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils.excel;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.exception.ExcelAnalysisException;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.xforceplus.domain.resource.ResourceExtendDto;
import com.xforceplus.domain.resource.ResourcesetExtendDto;
import com.xforceplus.tenant.core.exception.UnknownException;
import com.xforceplus.utils.excel.ResourcesetEnum;
import com.xforceplus.utils.excel.ResourcesetListener;
import com.xforceplus.utils.excel.ResourcesetWrapper;
import com.xforceplus.utils.excel.SimpleResourceEnum;
import com.xforceplus.utils.excel.SimpleResourceListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcesetExcelUtils {
    private static Logger logger = LoggerFactory.getLogger(ResourcesetExcelUtils.class);

    public static ResourcesetWrapper extract(String filePath) {
        ResourcesetWrapper result = new ResourcesetWrapper();
        ResourcesetListener resourcesetListener = new ResourcesetListener();
        SimpleResourceListener simpleResourceListener = new SimpleResourceListener();
        try {
            ExcelReader excelReader = EasyExcel.read((String)filePath).build();
            ReadSheet readSheet1 = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)0).headRowNumber(Integer.valueOf(0))).registerReadListener((ReadListener)resourcesetListener)).build();
            ReadSheet readSheet2 = ((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((Integer)1).headRowNumber(Integer.valueOf(0))).registerReadListener((ReadListener)simpleResourceListener)).build();
            excelReader.read(new ReadSheet[]{readSheet1, readSheet2});
            excelReader.finish();
        }
        catch (ExcelAnalysisException e) {
            if (e.getCause() != null && e.getCause() instanceof UnknownException) {
                throw (UnknownException)e.getCause();
            }
            throw e;
        }
        List<ResourcesetExtendDto> resourcesetExtendDtoList = resourcesetListener.getData();
        List<ResourceExtendDto> resourceExtendDtoList = simpleResourceListener.getData();
        result.setResourcesets(resourcesetExtendDtoList);
        result.setResources(resourceExtendDtoList);
        return result;
    }

    public static void writeV2007(String errorPath, ResourcesetWrapper wrapper) {
        try {
            ExcelWriter writer = EasyExcel.write((String)errorPath).build();
            if (CollectionUtils.isNotEmpty(wrapper.getResourcesets())) {
                WriteSheet writeSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)1, (String)"\u529f\u80fd\u96c6\u5bfc\u51fa\u6587\u4ef6").head(ResourcesetExcelUtils.createResourcesetHead(wrapper.isSkipReason()))).build();
                writer.write(ResourcesetExcelUtils.createResourcesetData(wrapper.getResourcesets(), wrapper.isSkipReason()), writeSheet);
            }
            if (CollectionUtils.isNotEmpty(wrapper.getResources())) {
                WriteSheet writeSheet2 = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)2, (String)"\u8d44\u6e90\u7801\u5bfc\u51fa\u6587\u4ef6").head(ResourcesetExcelUtils.createResourceHead(wrapper.isSkipReason()))).build();
                writer.write(ResourcesetExcelUtils.createResourceData(wrapper.getResources(), wrapper.isSkipReason()), writeSheet2);
            }
            writer.finish();
        }
        catch (Exception e) {
            throw new UnknownException("\u751f\u6210\u6587\u4ef6\u5931\u8d25\u3002");
        }
    }

    private static List<List<String>> createResourcesetHead(boolean skipReason) {
        ResourcesetEnum[] enums;
        ArrayList<List<String>> head = new ArrayList<List<String>>();
        ArrayList<String> titleHeadColumn = new ArrayList<String>();
        titleHeadColumn.add("\u5e8f\u53f7");
        head.add(titleHeadColumn);
        for (ResourcesetEnum item : enums = ResourcesetEnum.values()) {
            if (skipReason && item == ResourcesetEnum.reason) continue;
            ArrayList<String> headColumn = new ArrayList<String>();
            headColumn.add(item.getTitle());
            head.add(headColumn);
        }
        return head;
    }

    private static List<List<String>> createResourceHead(boolean skipReason) {
        SimpleResourceEnum[] enums;
        ArrayList<List<String>> head = new ArrayList<List<String>>();
        ArrayList<String> titleHeadColumn = new ArrayList<String>();
        titleHeadColumn.add("\u5e8f\u53f7");
        head.add(titleHeadColumn);
        for (SimpleResourceEnum item : enums = SimpleResourceEnum.values()) {
            if (skipReason && item == SimpleResourceEnum.reason) continue;
            ArrayList<String> headColumn = new ArrayList<String>();
            headColumn.add(item.getTitle());
            head.add(headColumn);
        }
        return head;
    }

    private static List<List<Object>> createResourcesetData(List<ResourcesetExtendDto> list, boolean skipReason) {
        ArrayList<List<Object>> object = new ArrayList<List<Object>>();
        for (int i = 0; i < list.size(); ++i) {
            ResourcesetExtendDto resourcesetExtendDto = list.get(i);
            ResourcesetEnum[] enums = ResourcesetEnum.values();
            ArrayList<String> da = new ArrayList<String>();
            da.add(String.valueOf(i + 1));
            for (ResourcesetEnum item : enums) {
                if (skipReason && item == ResourcesetEnum.reason) continue;
                Class<?> classObj = resourcesetExtendDto.getClass();
                try {
                    Method method = classObj.getMethod("get" + item.getFieldName().substring(0, 1).toUpperCase() + item.getFieldName().substring(1), new Class[0]);
                    Object value = method.invoke((Object)resourcesetExtendDto, new Object[0]);
                    if (value == null) {
                        value = "";
                    }
                    da.add(String.valueOf(value));
                }
                catch (Exception e) {
                    logger.error("\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
                }
            }
            object.add(da);
        }
        return object;
    }

    private static List<List<Object>> createResourceData(List<ResourceExtendDto> list, boolean skipReason) {
        ArrayList<List<Object>> object = new ArrayList<List<Object>>();
        for (int i = 0; i < list.size(); ++i) {
            ResourceExtendDto resourceExtendDto = list.get(i);
            SimpleResourceEnum[] enums = SimpleResourceEnum.values();
            ArrayList<String> da = new ArrayList<String>();
            da.add(String.valueOf(i + 1));
            for (SimpleResourceEnum item : enums) {
                if (skipReason && item == SimpleResourceEnum.reason) continue;
                Class<?> classObj = resourceExtendDto.getClass();
                try {
                    Method method = classObj.getMethod("get" + item.getFieldName().substring(0, 1).toUpperCase() + item.getFieldName().substring(1), new Class[0]);
                    Object value = method.invoke((Object)resourceExtendDto, new Object[0]);
                    if (value == null) {
                        value = "";
                    }
                    da.add(String.valueOf(value));
                }
                catch (Exception e) {
                    logger.error("\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
                }
            }
            object.add(da);
        }
        return object;
    }
}

