/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils.excel;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.xforceplus.domain.resource.ServiceApiExtendDto;
import com.xforceplus.tenant.core.exception.UnknownException;
import com.xforceplus.utils.excel.MyStringUtils;
import com.xforceplus.utils.excel.ServiceApiEnum;
import io.geewit.web.utils.JsonUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMethod;

public class ServiceApiListener
extends AnalysisEventListener {
    public static int IMPORT_LIMIT = 5000;
    private static Logger logger = LoggerFactory.getLogger(ServiceApiListener.class);
    private List<ServiceApiExtendDto> data = new ArrayList<ServiceApiExtendDto>();
    private Map titleList = null;
    private int rowNo = 0;
    private boolean isEnd = false;

    public void invoke(Object object, AnalysisContext context) {
        ++this.rowNo;
        Map item = (Map)object;
        if (item == null || item.isEmpty()) {
            return;
        }
        String firstColumn = (String)item.get(0);
        if (this.titleList == null) {
            if (firstColumn == null || !StringUtils.equals((CharSequence)firstColumn.trim(), (CharSequence)ServiceApiEnum.serviceApiPath.getTitle())) {
                return;
            }
            this.titleList = item;
        } else {
            if (this.isEnd) {
                return;
            }
            if (this.data.size() >= IMPORT_LIMIT + 1) {
                throw new UnknownException("\u5bfc\u5165\u6587\u4ef6\u5185\u5bb9\u884c\u6570\u4e0d\u80fd\u8d85\u8fc7" + IMPORT_LIMIT + "\u884c\u3002");
            }
            ServiceApiExtendDto serviceApiExtendDto = new ServiceApiExtendDto();
            Class<?> classObj = serviceApiExtendDto.getClass();
            for (int i = 0; i < this.titleList.size(); ++i) {
                String title = (String)this.titleList.get(i);
                ServiceApiEnum itineraryCheckEnum = ServiceApiEnum.getItemByTitle(title);
                if (itineraryCheckEnum == null) continue;
                Method method = null;
                try {
                    Method[] methods;
                    for (Method oneMethod : methods = classObj.getMethods()) {
                        if (!StringUtils.equals((CharSequence)oneMethod.getName(), (CharSequence)("set" + itineraryCheckEnum.getFieldName().substring(0, 1).toUpperCase() + itineraryCheckEnum.getFieldName().substring(1)))) continue;
                        method = oneMethod;
                    }
                    if (method == null) continue;
                    String value = (String)item.get(i);
                    Object transValue = null;
                    if (StringUtils.equals((CharSequence)"requestMethod", (CharSequence)itineraryCheckEnum.getFieldName())) {
                        if (StringUtils.isNotBlank((CharSequence)value)) {
                            transValue = RequestMethod.valueOf((String)value);
                        }
                    } else {
                        transValue = MyStringUtils.transValue(method.getParameterTypes()[0], value);
                    }
                    if (transValue == null) continue;
                    method.invoke((Object)serviceApiExtendDto, transValue);
                    continue;
                }
                catch (Exception e) {
                    logger.error("\u7cfb\u7edf\u5f02\u5e38\uff0ctitle==" + title + "itineraryCheckEnum=={}", (Object)JsonUtils.toJson((Object)((Object)itineraryCheckEnum)), (Object)e);
                }
            }
            this.data.add(serviceApiExtendDto);
        }
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
    }

    public List<ServiceApiExtendDto> getData() {
        return this.data;
    }

    public void setData(List<ServiceApiExtendDto> data) {
        this.data = data;
    }
}

