/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils.excel;

import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.xforceplus.domain.resource.ResourcesetExtendDto;
import com.xforceplus.tenant.core.exception.UnknownException;
import com.xforceplus.utils.excel.MyStringUtils;
import com.xforceplus.utils.excel.SimpleResourcesetEnum;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class SimpleResourcesetListener
extends AnalysisEventListener {
    public static final int IMPORT_LIMIT = 1000;
    private static Logger logger = LoggerFactory.getLogger(SimpleResourcesetListener.class);
    private List<ResourcesetExtendDto> data = new ArrayList<ResourcesetExtendDto>();
    private Map titleList = null;
    private int rowNo = 0;
    private boolean isEnd = false;

    public void invoke(Object object, AnalysisContext context) {
        ++this.rowNo;
        Map item = (Map)object;
        if (CollectionUtils.isEmpty((Map)item)) {
            return;
        }
        String firstColumn = (String)item.get(0);
        if (this.titleList == null) {
            if (firstColumn == null || !StringUtils.equals((CharSequence)firstColumn.trim(), (CharSequence)"\u5e8f\u53f7")) {
                return;
            }
            this.titleList = item;
        } else {
            if (this.isEnd) {
                return;
            }
            if (this.data.size() >= 1001) {
                throw new UnknownException("\u5bfc\u5165\u6587\u4ef6\u5185\u5bb9\u884c\u6570\u4e0d\u80fd\u8d85\u8fc71000\u884c\u3002");
            }
            ResourcesetExtendDto resourcesetExtendDto = new ResourcesetExtendDto();
            Class<?> classObj = resourcesetExtendDto.getClass();
            for (int i = 0; i < this.titleList.size(); ++i) {
                SimpleResourcesetEnum simpleResourcesetEnum;
                String title = (String)this.titleList.get(i);
                if (StringUtils.equals((CharSequence)title, (CharSequence)"\u5e8f\u53f7") || (simpleResourcesetEnum = SimpleResourcesetEnum.getItemByTitle(title)) == null) continue;
                Method method = null;
                try {
                    Method[] methods;
                    for (Method oneMethod : methods = classObj.getMethods()) {
                        if (!StringUtils.equals((CharSequence)oneMethod.getName(), (CharSequence)("set" + simpleResourcesetEnum.getFieldName().substring(0, 1).toUpperCase() + simpleResourcesetEnum.getFieldName().substring(1)))) continue;
                        method = oneMethod;
                    }
                    if (method == null) continue;
                    String value = (String)item.get(i);
                    Object transValue = MyStringUtils.transValue(method.getParameterTypes()[0], value);
                    if (transValue == null) continue;
                    method.invoke((Object)resourcesetExtendDto, transValue);
                    continue;
                }
                catch (Exception e) {
                    logger.error("\u7cfb\u7edf\u5f02\u5e38", (Throwable)e);
                }
            }
            this.data.add(resourcesetExtendDto);
        }
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
    }

    public List<ResourcesetExtendDto> getData() {
        return this.data;
    }

    public void setData(List<ResourcesetExtendDto> data) {
        this.data = data;
    }
}

