/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.utils.filetransfer;

import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import com.xforceplus.tower.file.client.model.Policy;
import com.xforceplus.tower.storage.StorageFactory;
import com.xforceplus.tower.storage.model.UploadFileRequest;
import io.geewit.utils.uuid.UUIDUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FileTransferUtilsService {
    private static final Logger log = LoggerFactory.getLogger(FileTransferUtilsService.class);
    private static final Logger logger = LoggerFactory.getLogger(FileTransferUtilsService.class);
    @Resource
    private StorageFactory storageFactory;
    private Integer expireDay = 3;
    private String appId = "tenant-service";

    public Long uploadInputStream(InputStream is, Long tenantId, Long userId) throws FileNotFoundException {
        String fileName = UUIDUtils.randomUUID();
        UploadFileRequest uploadFileRequest = new UploadFileRequest();
        uploadFileRequest.setAppId(this.appId);
        uploadFileRequest.setExpires(this.expireDay);
        uploadFileRequest.setFileName(fileName);
        uploadFileRequest.setPolicy(Policy.PRIVATE_POLICY);
        uploadFileRequest.setTenantId(tenantId);
        uploadFileRequest.setUserId(userId);
        uploadFileRequest.setOverwrite(Boolean.valueOf(true));
        uploadFileRequest.setInputStream(is);
        uploadFileRequest.setFilePath("/resources");
        return this.storageFactory.uploadByInputStream(uploadFileRequest);
    }

    public Long uploadInputStream(InputStream is) throws FileNotFoundException {
        Long tenantId = 0L;
        Long userId = 0L;
        if (null != UserInfoHolder.get()) {
            tenantId = UserInfoHolder.get().getTenantId();
            userId = UserInfoHolder.get().getId();
        }
        return this.uploadInputStream(is, tenantId, userId);
    }

    public Long upload(String filePath, Long userId, Long tenantId) throws FileNotFoundException {
        File file = new File(filePath);
        FileInputStream is = new FileInputStream(file);
        String fileName = UUIDUtils.randomUUID();
        UploadFileRequest uploadFileRequest = new UploadFileRequest();
        uploadFileRequest.setAppId(this.appId);
        uploadFileRequest.setExpires(this.expireDay);
        uploadFileRequest.setFileName(fileName);
        uploadFileRequest.setPolicy(Policy.PRIVATE_POLICY);
        uploadFileRequest.setTenantId(tenantId);
        uploadFileRequest.setUserId(userId);
        uploadFileRequest.setOverwrite(Boolean.valueOf(true));
        uploadFileRequest.setInputStream((InputStream)is);
        uploadFileRequest.setFilePath("/resources");
        return this.storageFactory.uploadByInputStream(uploadFileRequest);
    }

    public Long upload(String filePath) throws FileNotFoundException {
        Long tenantId = 0L;
        Long userId = 0L;
        if (null != UserInfoHolder.get()) {
            tenantId = UserInfoHolder.get().getTenantId();
            userId = UserInfoHolder.get().getId();
        }
        return this.upload(filePath, userId, tenantId);
    }

    public void download(String filePath, Long fileId, Long userId, Long tenantId) throws IOException {
        InputStream inputStream = this.storageFactory.downloadInputStream(userId, tenantId, fileId, "re.xlsx");
        byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
        FileUtils.writeByteArrayToFile((File)new File(filePath), (byte[])bytes, (boolean)false);
    }

    public void download(String filePath, Long fileId) throws IOException {
        Long tenantId = 0L;
        Long userId = 0L;
        try {
            IAuthorizedUser currentUser = UserInfoHolder.currentUser();
            tenantId = currentUser.getTenantId();
            userId = currentUser.getId();
        }
        catch (Exception e) {
            logger.warn("FileTransferUtilsService download2", (Throwable)e);
        }
        this.download(filePath, fileId, userId, tenantId);
    }
}

