package com.xforceplus;

import com.xforceplus.constants.EnvConstants;
import com.xforceplus.tower.storage.config.EnableFileService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.AbstractEnvironment;
import org.springframework.scheduling.annotation.EnableScheduling;

import java.util.Properties;


/**
 * @author geewit
 * 自动开启@EnableAutoConfiguration
 * 开启spring cache
 */
@EnableCaching
@EnableScheduling
@EnableFeignClients
@SpringBootApplication
@PropertySource(value = {"classpath:env/${" + AbstractEnvironment.ACTIVE_PROFILES_PROPERTY_NAME + "}/application.properties"}, encoding = "UTF-8", ignoreResourceNotFound = true)
@EnableFileService
public class Bootstrap {

    public static void main(String[] args) {
        String profile = System.getProperty(AbstractEnvironment.ACTIVE_PROFILES_PROPERTY_NAME, "unknown");
        System.setProperty("log4j2.formatMsgNoLookups", "true");
        Properties properties = new Properties();
        if (EnvConstants.DEFAULT.equals(profile)) {
            System.setProperty("log4j.skipJansi", "false");
            properties.put("logging.config", "classpath:env/default/log4j2.xml");
        } else if (StringUtils.containsAny(profile, EnvConstants.DEV, EnvConstants.FAT, EnvConstants.SIT, EnvConstants.UAT, EnvConstants.DEMO)) {
            properties.put("logging.config", "classpath:env/test/log4j2.xml");
        } else if (StringUtils.contains(profile, EnvConstants.PROD)) {
            properties.put("logging.config", "classpath:env/prod/log4j2.xml");
        } else {
            properties.put("logging.config", "classpath:env/test/log4j2.xml");
        }
        SpringApplication application = new SpringApplication(Bootstrap.class);
        application.setDefaultProperties(properties);
        application.run(args);
    }

}
