package com.xforceplus.business.account.controller;

import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.global.account.AccountPlatformRelApi;
import com.xforceplus.api.model.AccountPlatformRelModel.Request.ChangeState;
import com.xforceplus.api.model.AccountPlatformRelModel.Request.Query;
import com.xforceplus.api.model.AccountPlatformRelModel.Request.QueryByUserId;
import com.xforceplus.api.model.AccountPlatformRelModel.Request.Save;
import com.xforceplus.business.account.service.AccountPlatformRelService;
import com.xforceplus.entity.AccountPlatformRel;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;

import javax.validation.Valid;
import java.util.List;

/**
 * @author lengmz
 */
@SuppressWarnings("all")
@Api(value = "帐号平台相关接口", description = "帐号平台相关接口")
@Controller
public class AccountPlatformRelController implements AccountPlatformRelApi {
    private final static Logger logger = LoggerFactory.getLogger(AccountPlatformRelController.class);


    private final AccountPlatformRelService accountPlatformRelService;

    public AccountPlatformRelController(AccountPlatformRelService accountPlatformRelService) {
        this.accountPlatformRelService = accountPlatformRelService;
    }

    @ApiOperation(value = "绑定关系查询接口")
    @Override
    public ResponseEntity<Page<AccountPlatformRel>> page(@ApiParam(value = "request") Query query,
                                                         @ApiParam(value = "pageable") Pageable pageable) {
        Page<AccountPlatformRel> result = accountPlatformRelService.page(query, pageable);
        return ResponseEntity.ok(result);
    }

    @Override
    public ResponseEntity<AccountPlatformRel> create(Save model) {
        AccountPlatformRel result = accountPlatformRelService.save(model);
        return ResponseEntity.okWithCode(result);
    }


    @ApiOperation(value = "根据平台类型和平台id查询账户关联")
    @Override
    public ResponseEntity<AccountPlatformRel> info(int platformType, String platformId) {
        AccountPlatformRel result = accountPlatformRelService.getInfoByPlatformId(platformType, platformId);
        return ResponseEntity.okWithCode(result);
    }

    @ApiOperation(value = "根据userId查询账户关联")
    @Override
    public ResponseEntity<List<AccountPlatformRel>> queryByUserId(Long userId, QueryByUserId queryByUserId) {
        List<AccountPlatformRel> result = accountPlatformRelService.list(userId, queryByUserId.getPlatformType());
        return ResponseEntity.okWithCode(result);
    }

    @Override
    public ResponseEntity<String> updateState(ChangeState request) {
        accountPlatformRelService.updateState(request);
        return ResponseEntity.okWithCode("成功。");
    }

    @ApiOperation(value = "根据平台类型查询当前账户关联")
    @Override
    public ResponseEntity<List<AccountPlatformRel>> currentQuery(int platformType) {
        Long userId = UserInfoHolder.currentUser().getId();
        List<AccountPlatformRel> result = accountPlatformRelService.list(userId, platformType);
        return ResponseEntity.okWithCode(result);
    }

}
