package com.xforceplus.business.account.controller;

import com.fasterxml.jackson.annotation.JsonView;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.global.account.LoginLogApi;
import com.xforceplus.api.model.LoginLogModel;
import com.xforceplus.business.account.service.LoginLogService;
import com.xforceplus.entity.LoginLog;
import io.geewit.core.jackson.view.View;
import io.geewit.data.jpa.essential.domain.PageableFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;

import javax.validation.Valid;


@SuppressWarnings("all")
@Api(value = "登录日志相关接口", description = "登录日志相关接口")
@Validated
@Controller
public class LoginLogController implements LoginLogApi {
    private final static Logger logger = LoggerFactory.getLogger(LoginLogController.class);

    @Autowired
    private LoginLogService loginLogService;

    @JsonView(View.List.class)
    @ApiOperation(value = "获取登录信息分页", notes = "通过分页参数，获取登录信息分页")
    @Override
    public ResponseEntity<Page<LoginLog>> page(@ApiParam(value = "request") LoginLogModel.Request.Query query,
                                               @ApiParam(value = "pageable") Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort(pageable, Sort.by(Sort.Direction.DESC, "loginTime"));
        return ResponseEntity.ok(null);
    }

    @JsonView(View.List.class)
    @ApiOperation(value = "新增登录信息")
    @Override
    public ResponseEntity<String> create(@ApiParam(value = "loginLog", required = true) LoginLogModel.Request.Save save) {
        loginLogService.create(save);
        return ResponseEntity.ok();
    }

}
