package com.xforceplus.business.account.controller;

import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.global.account.SsoAccountApi;
import com.xforceplus.api.model.SsoAccountModel;
import com.xforceplus.business.account.service.SsoAccountService;
import com.xforceplus.entity.Account;
import com.xforceplus.utils.PhoneUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;

import javax.annotation.Resource;
import javax.validation.Valid;

/**
 * @author lengmz
 */
@SuppressWarnings("all")
@Api(value = "单点登录-帐号相关接口", description = "单点登录-帐号相关接口")
@Validated
@Controller
@Slf4j
public class SsoAccountController implements SsoAccountApi {

    @Resource
    private SsoAccountService ssoAccountService;

    /**
     * 此接口准备下线，后续使用 @see "UserController.create()" 来新增用户.
     *
     * @param model 保存对象
     * @param <T>
     * @return
     */
    @Deprecated
    @ApiOperation(value = "单点登录-新增帐号")
    @Override
    public ResponseEntity<Account> create(@ApiParam(value = "account", required = true) SsoAccountModel.Request.Save model) {
        if (!PhoneUtils.checkPhoneNumber(model.getTelPhone())) {
            throw new IllegalArgumentException("手机格式错误");
        }
        Account result = ssoAccountService.save(model);
        return ResponseEntity.ok(result);
    }

}
