/*
 * Copyright (c)  2015~2021, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: AccountPubDTO.java   2021-01-13 14-31-27
 * Author: Evan
 */
package com.xforceplus.business.account.dto;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

/**
 * <p>
 * Title: 账号信息 -消息订阅
 * </p>
 * <p>
 * Description: 账号信息 -消息订阅
 * </p>
 * <p>
 * Copyright: 2015~2021
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2021-01-13 14-31-27
 * @since V1.0
 */
@Setter
@Getter
@ToString
public class AccountPubDTO implements Serializable {

    /**
     * 账号Id
     */
    private Long accountId;
    /**
     * Email
     */
    private String email;

    /**
     * 用户名
     */
    private String username;
    /**
     * 手机号
     */
    private String telPhone;

    /**
     * 渠道-全部，默认为全部
     */
    private String channel;

    public void setEmail(String email) {
        this.email = StringUtils.trim(email);
    }

    public void setUsername(String username) {
        this.username = StringUtils.trim(username);
    }

    public void setTelPhone(String telPhone) {
        this.telPhone = StringUtils.trim(telPhone);
    }

    public void setChannel(String channel) {
        this.channel = StringUtils.trim(channel);
    }
}
