package com.xforceplus.business.account.service;

import com.xforceplus.business.wechat.service.WechatConfigProperties;
import io.geewit.web.utils.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;


/**
 * @author lengmz
 * @since 2020/3/13
 */
@Service
@Slf4j
public class AccessTokenService {
    private static final Logger logger = LoggerFactory.getLogger(AccessTokenService.class);

    @Resource
    private RestTemplate restTemplate;
    @Resource
    private WechatConfigProperties wechatConfigProperties;

    public AccessTokenResp accessToken() {
        String routesUrl = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s";
        routesUrl = String.format(routesUrl, wechatConfigProperties.getAppId(), wechatConfigProperties.getAppSecret());
        logger.info("routesUrl=={}", routesUrl);
        ResponseEntity<String> responseEntity = restTemplate.getForEntity(routesUrl, String.class);
        String response = responseEntity.getBody();
        logger.info("response = {}", response);
        return JsonUtils.fromJson(response, AccessTokenResp.class);
    }

}
