package com.xforceplus.business.account.service;

import com.xforceplus.business.enums.AccountPlatformTypeEnum;
import com.xforceplus.business.enums.DidiAccountEnum;
import com.xforceplus.business.tenant.service.UserService;
import com.xforceplus.domain.account.DidiAccountDataDto;
import com.xforceplus.entity.AccountPlatformRel;
import com.xforceplus.entity.User;
import com.xforceplus.utils.DidiSignUtils;
import io.geewit.web.utils.JsonUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;


/**
 * 滴滴账户服务
 *
 * @author lengmz
 */
@Service
@Slf4j
public class DidiAccounService {
    @Resource
    private AccountPlatformRelService accountPlatformRelService;
    @Resource
    private UserService userService;


    public DidiAccountEnum.Status saveNotifyResult(String data, Long appId, String timestamp, String sign) throws NoSuchAlgorithmException {
        if (StringUtils.isBlank(data)) {
            return DidiAccountEnum.Status.CHECK_FAIL;
        }
        if (appId == null) {
            return DidiAccountEnum.Status.CHECK_FAIL;
        }
        if (StringUtils.isBlank(timestamp)) {
            return DidiAccountEnum.Status.CHECK_FAIL;
        }
        if (StringUtils.isBlank(sign)) {
            return DidiAccountEnum.Status.CHECK_FAIL;
        }
        Map<String, String> dataMap = new HashMap<>(4);
        dataMap.put("appId", String.valueOf(appId));
        dataMap.put("data", data);
        dataMap.put("timestamp", timestamp);
        if (!DidiSignUtils.isRegal(dataMap, sign)) {
            return DidiAccountEnum.Status.SIGN_ILLEGAL;
        }
        DidiAccountDataDto didiAccountDataDto = JsonUtils.fromJson(data, DidiAccountDataDto.class);
        saveWithUserId(didiAccountDataDto.getThirdUserId(), AccountPlatformTypeEnum.DIDI.getValue(), didiAccountDataDto.getOperate(), new Date(Long.valueOf(didiAccountDataDto.getUpdateTime())));
        return DidiAccountEnum.Status.SUCCESS;
    }

    public <T extends AccountPlatformRel> T saveWithUserId(String userId, int platformType, int status, Date enableTime) {
        Optional<User> optionalUser = userService.findUserById(Long.valueOf(userId));
        User user = optionalUser.orElseThrow(() -> new IllegalArgumentException("所传userId有误。"));
        AccountPlatformRel accountPlatformRel = accountPlatformRelService.getAccountPlatformRel(platformType, userId);
        if (accountPlatformRel == null) {
            accountPlatformRel = new AccountPlatformRel();
            accountPlatformRel.setAccountId(user.getAccountId());
            accountPlatformRel.setCreateTime(new Date());
        }
        accountPlatformRel.setStatus(status);
        accountPlatformRel.setEnableTime(enableTime);
        accountPlatformRel.setUpdateTime(new Date());
        return (T) accountPlatformRelService.saveAccountPlatformRel(accountPlatformRel);
    }


}
