package com.xforceplus.business.account.service;

import com.xforceplus.api.model.LoginLogModel;
import com.xforceplus.dao.LoginLogDao;
import com.xforceplus.entity.LoginLog;
import io.geewit.core.utils.reflection.BeanUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Optional;

/**
 * @author duanhy
 * @date 2022/1/14 10:10
 */
@Service
@Slf4j
public class LoginLogService {

    private final LoginLogDao loginLogDao;

    public LoginLogService(LoginLogDao loginLogDao) {
        this.loginLogDao = loginLogDao;
    }

    @Transactional(rollbackFor = Exception.class)
    public void create(LoginLogModel.Request.Save save) {
        log.info("用户登录:{},accountId:{},userId:{},loginTime:{}", save.getLoginName(), save.getAccountId(), save.getUserId(), save.getLoginTime());
        Page<LoginLog> page = loginLogDao.findAll((Specification<LoginLog>) (root, query, builder) -> builder.equal(root.<Long>get("accountId"), save.getAccountId()), Pageable.ofSize(1));
        Optional<LoginLog> loginLogOptional = page.stream().findFirst();
        LoginLog entity;
        if (loginLogOptional.isPresent()) {
            loginLogDao.updateLoginTime(save.getAccountId(), save.getLoginName(), save.getUserId(), save.getLoginTime());
        } else {
            entity = new LoginLog();
            BeanUtils.copyProperties(save, entity);
            loginLogDao.saveAndFlush(entity);
        }
    }

}
