package com.xforceplus.business.account.service;

import com.xforceplus.api.model.PasswordHistoryModel;
import com.xforceplus.dao.PasswordHistoryDao;
import com.xforceplus.entity.PasswordHistory;
import com.xforceplus.query.PasswordHistoryQueryHelper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 *
 */
@Slf4j
@Service
public class PasswordHistoryService {
    private final PasswordHistoryDao passwordHistoryDao;


    public PasswordHistoryService(PasswordHistoryDao passwordHistoryDao) {
        this.passwordHistoryDao = passwordHistoryDao;
    }

    public boolean existPasswordInHistory(long accountId, String password, int maxRows) {
        PasswordHistoryModel.Request.Query query = new PasswordHistoryModel.Request.Query();
        query.setAccountId(accountId);
        query.setPassword(password);
        Page<PasswordHistory> page = passwordHistoryDao.findAll(PasswordHistoryQueryHelper.querySpecification(query), Pageable.ofSize(maxRows));
        return !page.isEmpty();
    }

    @Transactional(rollbackFor = Exception.class)
    public void savePassword(long accountId, String password, int maxRows) {
        if (maxRows <= 0) {
            log.info("maxRows <= 0, do nothing");
        }
        List<PasswordHistory> histories = passwordHistoryDao.findByAccountId(accountId);
        int size = histories.size();
        if (size >= maxRows) {
            for (int i = 0; i < (maxRows - size); i++) {
                PasswordHistory deletingPasswordHistory = histories.get(i);
                if (i == 0) {
                    deletingPasswordHistory.setPassword(password);
                    passwordHistoryDao.save(deletingPasswordHistory);
                } else {
                    passwordHistoryDao.deleteById(deletingPasswordHistory.getId());
                }
            }
        } else {
            PasswordHistory passwordHistory = new PasswordHistory();
            passwordHistory.setAccountId(accountId);
            passwordHistory.setPassword(password);
            passwordHistoryDao.save(passwordHistory);
        }
    }
}
