package com.xforceplus.business.account.service;

import com.xforceplus.api.model.SsoAccountModel.Request.Save;
import com.xforceplus.dao.AccountDao;
import com.xforceplus.dao.TenantDao;
import com.xforceplus.dao.UserDao;
import com.xforceplus.entity.Account;
import com.xforceplus.entity.User;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;


/**
 * 单点登录账号
 *
 * @author lnegmz
 */
@Service
@Slf4j
public class SsoAccountService {

    public SsoAccountService(TenantDao tenantDao, AccountService accountService, AccountDao accountDao, UserDao userDao) {
        this.tenantDao = tenantDao;
        this.accountService = accountService;
        this.accountDao = accountDao;
        this.userDao = userDao;
    }

    private final AccountDao accountDao;
    private final UserDao userDao;
    private final TenantDao tenantDao;
    private final AccountService accountService;
    
    @Transactional(rollbackFor = Exception.class)
    public Account save(Save model) {
        Long tenantId = tenantDao.findTenantIdByTenantCode(model.getTenantCode());
        if (tenantId == null) {
            throw new IllegalArgumentException("传入的租户编号(" + model.getTenantCode() + ")有误");
        }
        Account account = this.saveAccount(model);
        List<User> users = userDao.findByTenantIdAndAccountId(tenantId, account.getAccountId());
        User user = users.stream().findFirst().orElseGet(() -> {
            User newUser = new User();
            newUser.setTenantId(tenantId);
            newUser.setAccountId(account.getAccountId());
            return newUser;
        });
        user.setUserPhone(model.getTelPhone());
        user.setUserEmailAddr(model.getEmail());
        user.setUserName(model.getUsername());
        userDao.saveAndFlush(user);
        return account;
    }

    private Account saveAccount(Save save) {
        Account account = null;
        String username = null;
        if (StringUtils.isNotBlank(save.getUsername())) {
            username = save.getTenantCode() + save.getUsername();
        }
        if (StringUtils.isNotBlank(save.getTelPhone())) {
            account = accountDao.findByTelPhone(save.getTelPhone());
        }
        if (account == null && StringUtils.isNotBlank(save.getEmail())) {
            account = accountDao.findByEmail(save.getEmail());
        }
        if (account == null && StringUtils.isNotBlank(username)) {
            account = accountDao.findByUsername(username);
        }
        if (account == null) {
            account = new Account();
            account.setTelPhone(save.getTelPhone());
            account.setEmail(save.getEmail());
            account.setUsername(username);
            account.setPassword("no_password");
        }
        if (save.getStatus() != null) {
            account.setStatus(save.getStatus());
        }
        return accountService.saveAndFlush(account);
    }

}
