package com.xforceplus.business.cache.controller;

import com.xforceplus.api.common.Uri;
import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.business.cache.service.CacheService;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import io.swagger.annotations.Api;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.annotation.Resource;

@SuppressWarnings("all")
@Api(value = "缓存相关接口", description = "缓存相关接口")
@Validated
@Controller
public class CacheController {
    private final static Logger logger = LoggerFactory.getLogger(CacheController.class);

    @Resource
    private CacheService cacheService;

    @AuthorizedDefinition(resources = {"xforce:admin:ops"})
    @ResponseBody
    @RequestMapping(name = "清空所有缓存", value = Uri.PATH_PREFIX + "/global" + Uri.API_VERSION + "/cache/all/clear", method = RequestMethod.GET)
    public ResponseEntity<String> clearAll() {
        return ResponseEntity.ok("清空所有缓存完成");
    }

    @AuthorizedDefinition(resources = {"xforce:admin:ops"})
    @ResponseBody
    @RequestMapping(name = "清空指定缓存", value = Uri.PATH_PREFIX + "/global" + Uri.API_VERSION + "/cache/{cacheName}/clear", method = RequestMethod.GET)
    public ResponseEntity<String> clear(@PathVariable("cacheName") String cacheName) {
        return ResponseEntity.ok("清空指定缓存(" + cacheName + ")完成");
    }

    @ApiIgnore
    @ResponseBody
    @RequestMapping(name = "redis删除指定key", value = Uri.PATH_PREFIX + "/global" + Uri.API_VERSION + "/cache/del", method = RequestMethod.GET)
    public ResponseEntity<String> del(@RequestParam("key") String key) {
        Boolean result = cacheService.del(key);
        return ResponseEntity.ok(result.toString());
    }
}
