/*
 * Copyright (c)  2015~2025, Xforceplus
 * All rights reserved.
 * Project: tenant-service
 * ClassName: ClientResourceController
 * Date: 2021-06-22 14:43:02
 * Author: zhouxin
 */
package com.xforceplus.business.client.controller;

import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.global.client.ClientResourceApi;
import com.xforceplus.business.client.service.ClientResourcesetRelService;
import io.swagger.annotations.Api;
import java.util.Set;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Controller;

/**
 * @author zhouxin
 */
@Api(value = "client资源码相关接口", tags = {"client resources"})
@Controller
@RequiredArgsConstructor
public class ClientResourceController implements ClientResourceApi {

    private final ClientResourcesetRelService clientResourcesetRelService;

    @Override
    public ResponseEntity<Set<String>> clientResources(String clientId) {
        return ResponseEntity.ok(clientResourcesetRelService.getClientResource(clientId));
    }

    @Override
    public void refresh(String clientId) {
        clientResourcesetRelService.evictClientResourceCache(clientId);
    }
}
