package com.xforceplus.business.common.controller;

import com.xforceplus.business.company.service.CompanyService;
import com.xforceplus.business.tenant.service.*;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.entity.Tenant;
import com.xforceplus.entity.User;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Optional;

@SuppressWarnings("all")
public class AbstractController {
    private final static Logger logger = LoggerFactory.getLogger(AbstractController.class);

    @Autowired
    protected TenantService tenantService;

    @Autowired
    protected UserService userService;

    @Autowired
    protected OrgService orgService;

    @Autowired
    protected RoleService roleService;
    @Autowired
    protected PreRoleService preRoleService;
    @Autowired
    protected CompanyService companyService;

    public long toTenantId(String tenantKey, Boolean byCode) {
        if (StringUtils.isBlank(tenantKey)) {
            String message = "租户id不能为空(" + tenantKey + ")";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        Long tenantId = null;
        String tenantCode = null;
        if(byCode != null && byCode) {
            tenantCode = tenantKey;
        } else {
            try {
                tenantId = Long.parseLong(tenantKey);
            } catch (NumberFormatException e) {
                if(byCode != null) {
                    String message = "非法的租户id(" + tenantKey + ")";
                    logger.warn(message);
                    throw new IllegalArgumentException(message);
                }
                logger.info(e.getMessage() + ", tenantKey: " + tenantKey);
                tenantCode = tenantKey;
            }
        }

        if (tenantId != null && !String.valueOf(tenantId).equals(tenantKey)) {
            tenantCode = tenantKey;
        }
        if (StringUtils.isNotBlank(tenantCode)) {
            tenantId = tenantService.findTenantByCode(tenantCode);
        }
        if (tenantId == null || tenantId <= 0) {
            String message = "非法的租户id(" + tenantId + ")";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        return tenantId;
    }

    public Tenant toTenant(String tenantKey) {
        if (StringUtils.isBlank(tenantKey)) {
            String message = "租户id不能为空(" + tenantKey + ")";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        Tenant tenant;
        try {
            tenant = tenantService.findById(Long.parseLong(tenantKey));
        } catch (NumberFormatException e) {
            String message = e.getMessage() + ", tenantKey: " + tenantKey;
            logger.warn(message);
            tenant = tenantService.findByCode(tenantKey);
        }
        if (tenant == null) {
            String message = "非法的租户id(" + tenantKey + ")";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        return tenant;
    }

    public long toUserId(long tenantId, String userKey, Boolean byCode) {
        if (StringUtils.isBlank(userKey)) {
            String message = "用户id不能为空(" + userKey + ")";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        Long userId = null;
        String userCode = null;
        if(byCode != null && byCode) {
            userCode = userKey;
        } else {
            try {
                userId = Long.parseLong(userKey);
            } catch (NumberFormatException e) {
                if(byCode != null) {
                    String message = "非法的用户id(" + userKey + ")";
                    logger.warn(message);
                    throw new IllegalArgumentException(message);
                }
                logger.info(e.getMessage() + ", userKey: " + userKey);
                userCode = userKey;
            }
        }

        if (userId != null && !String.valueOf(userId).equals(userKey)) {
            userCode = userKey;
        }
        if (StringUtils.isNotBlank(userCode)) {
//            userId = userService.findIdByTenantIdAndCode(tenantId, userCode);
            Optional<User> userOptional = userService.findUserByTenantIdAndUserCode(tenantId, userCode,false, null);
            if(userOptional.isPresent()){
                userId = userOptional.get().getId();
            }
        }

        if (userId == null || userId <= 0) {
            String message = "非法的用户id(" + userKey + ")";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        return userId;
    }

    public long toOrgId(long tenantId, String orgKey, Boolean byCode) {
        if (StringUtils.isBlank(orgKey)) {
            String message = "组织id不能为空(" + orgKey + ")";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        Long orgId = null;
        String orgCode = null;
        if(byCode != null && byCode) {
            orgCode = orgKey;
        } else {
            try {
                orgId = Long.parseLong(orgKey);
            } catch (NumberFormatException e) {
                if(byCode != null) {
                    String message = "非法的组织code(" + orgKey + ")";
                    logger.warn(message);
                    throw new IllegalArgumentException(message);
                }
                logger.info(e.getMessage() + ", orgKey: " + orgKey);
                orgCode = orgKey;
            }
        }

        if (orgId != null && !String.valueOf(orgId).equals(orgKey)) {
            orgCode = orgKey;
        }
        if (StringUtils.isNotBlank(orgCode)) {
            orgId = orgService.findIdByTenantIdAndCode(tenantId, orgCode);
        }
        if (orgId == null || orgId <= 0) {
            String message = "非法的组织code(" + orgKey + ")";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        if (byCode == null || !byCode) {
            boolean existOrg = orgService.existByTenantIdAndOrgId(tenantId, orgId);
            if(!existOrg) {
                String message = "非法的组织id(" + orgKey + ")";
                logger.warn(message);
                throw new IllegalArgumentException(message);
            }
        }

        return orgId;
    }

    public OrgStruct toOrg(long tenantId, String orgKey, Boolean byCode) {
        if (StringUtils.isBlank(orgKey)) {
            String message = "组织id不能为空(" + orgKey + ")";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        OrgStruct org;
        Long orgId = null;
        String orgCode = null;
        if(byCode != null && byCode) {
            orgCode = orgKey;
        } else {
            try {
                orgId = Long.parseLong(orgKey);
            } catch (NumberFormatException e) {
                if(byCode != null) {
                    String message = "非法的组织code(" + orgKey + ")";
                    logger.warn(message);
                    throw new IllegalArgumentException(message);
                }
                logger.info(e.getMessage() + ", orgKey: " + orgKey);
                orgCode = orgKey;
            }
        }

        if (orgId != null && !String.valueOf(orgId).equals(orgKey)) {
            orgCode = orgKey;
        }
        if (StringUtils.isNotBlank(orgCode)) {
            List<OrgStruct> orgs = orgService.findByTenantIdAndOrgCode(tenantId, orgCode);
            if (orgs.isEmpty()) {
                String message = "不存在的组织code(" + orgKey + ")";
                logger.warn(message);
                throw new IllegalArgumentException(message);
            } else {
                if (orgs.size() > 1) {
                    String message = "组织code(" + orgKey + ")存在重复";
                    logger.warn(message);
                }
                org = orgs.stream().findFirst().get();
            }
        } else {
            String message = "组织code不能为空";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        if (org == null) {
            String message = "非法的组织code(" + orgKey + ")";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        if (byCode == null || !byCode) {
            org = orgService.findByTenantIdAndId(tenantId, orgId);
            if(org == null) {
                String message = "非法的组织id(" + orgKey + ")";
                logger.warn(message);
                throw new IllegalArgumentException(message);
            }
        }

        return org;
    }

    public long toRoleId(long tenantId, String roleKey, Boolean byCode) {
        if (StringUtils.isBlank(roleKey)) {
            String message = "角色id不能为空(" + roleKey + ")";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        Long roleId = null;
        String roleCode = null;
        if(byCode != null && byCode) {
            roleCode = roleKey;
        } else {
            try {
                roleId = Long.parseLong(roleKey);
            } catch (NumberFormatException e) {
                if(byCode != null) {
                    String message = "非法的角色id(" + roleKey + ")";
                    logger.warn(message);
                    throw new IllegalArgumentException(message);
                }
                logger.info(e.getMessage() + ", roleKey: " + roleKey);
                roleCode = roleKey;
            }
        }
        if (roleId != null && !String.valueOf(roleId).equals(roleKey)) {
            roleCode = roleKey;
        }
        if (StringUtils.isNotBlank(roleCode)) {
            roleId = roleService.findIdByTenantIdAndCode(tenantId, roleCode);
        }
        if (roleId == null || roleId <= 0) {
            String message = "非法的角色id(" + roleKey + ")";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        return roleId;
    }

    public long toCompanyId(String companyKey, boolean byTaxNum) {
        if (StringUtils.isBlank(companyKey)) {
            String message = "公司Key不能为空(" + companyKey + ")";
            logger.warn(message);
            throw new IllegalArgumentException(message);
        }
        Long companyId;
        if (!byTaxNum) {
            try {
                companyId = Long.parseLong(companyKey);
            } catch (NumberFormatException e) {
                String message = e.getMessage() + ", companyKey: " + companyKey;
                logger.info(message);
                Optional<Long> optional = companyService.findIdByTaxNum(companyKey);
                if (optional.isPresent()) {
                    companyId = optional.get();
                } else {
                    message = "非法的公司税号(" + companyKey + ")";
                    logger.warn(message);
                    throw new IllegalArgumentException(message);
                }
            }
        } else {
            Optional<Long> optional = companyService.findIdByTaxNum(companyKey);
            if (optional.isPresent()) {
                companyId = optional.get();
            } else {
                String message = "非法的公司税号(" + companyKey + ")";
                logger.warn(message);
                throw new IllegalArgumentException(message);
            }
        }
        return companyId;
    }
}
