package com.xforceplus.business.company.controller;

import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.global.company.CompanyApplyApi;
import com.xforceplus.api.model.CompanyApplyModel;
import com.xforceplus.api.model.CompanyApplyModel.Request.ApplicationProcess;
import com.xforceplus.api.model.CompanyApplyModel.Request.Query;
import com.xforceplus.business.company.service.CompanyApplyService;
import com.xforceplus.entity.CompanyApply;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import io.geewit.data.jpa.essential.domain.PageableFactory;
import io.swagger.annotations.Api;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;

import javax.validation.Valid;
import javax.validation.constraints.Min;

@SuppressWarnings("all")
@Api(value = "公司相关接口", description = "公司相关接口")
@Validated
@Controller
public class CompanyApplyController implements CompanyApplyApi {
    private final static Logger logger = LoggerFactory.getLogger(CompanyApplyController.class);

    private final CompanyApplyService companyApplyService;

    public CompanyApplyController(CompanyApplyService companyApplyService) {
        this.companyApplyService = companyApplyService;
    }

    @AuthorizedDefinition(resources = {"xforce:business:company-apply:read"})
    @Override
    public ResponseEntity<Page<CompanyApply>> page(Query query, Pageable pageable) {
        Pageable currentPageable = PageableFactory.ofDefaultSort(pageable, Sort.by(Sort.Direction.DESC, "createTime"));
        Page<CompanyApply> page = companyApplyService.page(query, currentPageable);
        return ResponseEntity.ok(page);
    }

    @AuthorizedDefinition(resources = {"xforce:business:company-apply:read"})
    @Override
    public ResponseEntity<CompanyApply> info(long applicationId) {
        CompanyApply result = companyApplyService.findById(applicationId);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources = {"xforce:business:company-apply:save"})
    @Override
    public ResponseEntity<String> approve(long applicationId, String reason) {
        companyApplyService.approve(applicationId, reason);
        return ResponseEntity.ok("审核通过成功");
    }

    @AuthorizedDefinition(resources = {"xforce:business:company-apply:save"})
    @Override
    public ResponseEntity<String> decline(long applicationId, String reason) {
        companyApplyService.decline(applicationId, reason);
        return ResponseEntity.ok("审核驳回成功");
    }

    @AuthorizedDefinition(resources = {"xforce:business:company-apply:save"})
    @Override
    public ResponseEntity<CompanyApplyModel.Response.ApplicationProcessResult> batchApprove(ApplicationProcess applicationProcess) {
        CompanyApplyModel.Response.ApplicationProcessResult result = companyApplyService.approve(applicationProcess);
        return ResponseEntity.ok(result);
    }

    @AuthorizedDefinition(resources = {"xforce:business:company-apply:save"})
    @Override
    public ResponseEntity<CompanyApplyModel.Response.ApplicationProcessResult> batchDecline(ApplicationProcess applicationProcess) {
        CompanyApplyModel.Response.ApplicationProcessResult result = companyApplyService.decline(applicationProcess);
        return ResponseEntity.ok(result);
    }
}
