/*
 * Copyright (c)  2015~2021, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: CompanyHisController.java   2021-01-12 15-28-02
 * Author: Evan
 */
package com.xforceplus.business.company.controller;

import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.global.company.CompanyHistoryApi;
import com.xforceplus.business.company.service.CompanyHistoryService;
import com.xforceplus.domain.company.CompanyHisDTO;
import com.xforceplus.entity.Company;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.Optional;

/**
 * <p>
 * Title: 公司履历Controller接口
 * </p>
 * <p>
 * Description: 公司履历Controller接口
 * </p>
 * <p>
 * Copyright: 2015~2021
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <>Creation Time:</b> 2021-01-12 15-28-02x
 * @since V1.0
 */
@RestController
@Api(value = "公司履历接口")
public class CompanyHistoryController implements CompanyHistoryApi {


    private final CompanyHistoryService companyHisService;

    public CompanyHistoryController(CompanyHistoryService companyHisService) {
        this.companyHisService = companyHisService;
    }

    @ApiOperation(value = "根据公司履历的税号查询当前公司信息", notes = "根据公司履历的税号查询当前公司信息")
    @Override
    public ResponseEntity<Company> get(String taxNum) {
        Optional<Company> optionalCompany = companyHisService.findByHisTaxNum(taxNum);
        //暂时未加扩展信息
        //未查询到数据返回为空
        return optionalCompany.map(ResponseEntity::ok).orElseGet(() -> ResponseEntity.fail("0", "未找到相应的数据"));
    }


    /**
     * 根据公司履历的税号查询当前公司信息
     *
     * @param taxNum   税号
     * @param pageable
     * @return ResponseEntity<CompanyDto>
     */
    @SuppressWarnings("AlibabaLowerCamelCaseVariableNaming")
    @Override
    @ApiOperation(value = "根据公司税号查询公司公司履历列表", notes = "根据公司税号查询公司公司履历列表")
    public ResponseEntity<Page<CompanyHisDTO>> hisPage(String taxNum, Pageable pageable) {
        Page<CompanyHisDTO> companyHisDTOS = companyHisService.pageHistory(taxNum, pageable);
        return ResponseEntity.ok(companyHisDTOS);
    }
}
