package com.xforceplus.business.company.controller;

import com.xforceplus.api.common.response.ResponseEntity;
import com.xforceplus.api.current.company.CompanyTenantRelApi;
import com.xforceplus.api.model.CompanyTenantRelModel.*;
import com.xforceplus.business.company.service.CompanyTenantRelOperationProcess;
import com.xforceplus.business.company.service.CompanyTenantRelService;
import com.xforceplus.domain.tenant.TenantDto;
import com.xforceplus.entity.CompanyTenantRel;
import com.xforceplus.tenant.security.autoscan.annotation.AuthorizedDefinition;
import com.xforceplus.tenant.security.core.context.UserInfoHolder;
import com.xforceplus.tenant.security.core.domain.IAuthorizedUser;
import io.geewit.data.jpa.essential.domain.PageableFactory;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;

import javax.validation.Valid;
import javax.validation.constraints.Min;


@SuppressWarnings("all")
@Api(value = "公司租户关联关系相关接口", description = "公司租户关联关系相关接口")
@Validated
@Controller
public class CompanyTenantRelController implements CompanyTenantRelApi {
    private final static Logger logger = LoggerFactory.getLogger(CompanyTenantRelController.class);

    private final CompanyTenantRelService companyTenantRelService;

    @Autowired
    private CompanyTenantRelOperationProcess operationProcess;

    public CompanyTenantRelController(CompanyTenantRelService companyTenantRelService) {
        this.companyTenantRelService = companyTenantRelService;
    }

    @ApiOperation(value = "公司租户关联关系分页")
    @AuthorizedDefinition(resources = {"xforce:ucenter:multitanent:read"})
    @Override
    public ResponseEntity<Page<CompanyTenantRel>> page(Request.Query query, Pageable pageable) {
        IAuthorizedUser authorizedUser = UserInfoHolder.currentUser();
        TenantDto hostTenant = null;
        if(query.isThisIsHost()) {
            query.setTenantId(authorizedUser.getTenantId());
            hostTenant = new TenantDto();
            hostTenant.setTenantName(authorizedUser.getTenantName());
            hostTenant.setTenantCode(authorizedUser.getTenantCode());
        } else {
            query.setRelatedTenantId(authorizedUser.getTenantId());
        }

        Pageable currentPageable = PageableFactory.ofDefaultSort(pageable, Sort.by(Sort.Direction.DESC, "createTime"));
        Page<CompanyTenantRel> page = companyTenantRelService.page(query, currentPageable);
        for(CompanyTenantRel rel : page) {
            if(!query.isThisIsHost()) {
                hostTenant = companyTenantRelService.findHostTenantByCompanyId(rel.getCompanyId());
            }
            rel.fillHostTenant(hostTenant);
        }
        return ResponseEntity.ok(page);
    }

    @ApiOperation(value = "解除公司租户关联关系")
    @AuthorizedDefinition(resources = {"xforce:ucenter:multitanent:relationship:save"})
    @Override
    public ResponseEntity<String> unrelate(long relId) {
        operationProcess.unrelateById(relId);
        return ResponseEntity.ok("成功解除关系");
    }

    @ApiOperation(value = "获取公司租户关联关系详情")
    @AuthorizedDefinition(resources = {"xforce:ucenter:multitanent:read"})
    @Override
    public ResponseEntity<Response.Info> info(long relId) {
        Response.Info info = companyTenantRelService.info(relId);
        return ResponseEntity.ok(info);
    }

    @ApiOperation(value = "更新公司租户关联关系配置")
    @AuthorizedDefinition(resources = {"xforce:ucenter:multitanent:policy:save"})
    @Override
    public ResponseEntity<String> update(long relId, Request.Update model) {
        companyTenantRelService.update(relId, model);
        return ResponseEntity.ok("更新成功");
    }

}
