/*
 * Copyright (c)  2015~2021, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: CompanyServicePackagePubDTO.java   2021-01-13 14-22-57
 * Author: Evan
 */
package com.xforceplus.business.company.dto;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Title:  公司服务包绑定和解绑
 * </p>
 * <p>
 * Description: 公司服务包绑定和解绑
 * </p>
 * <p>
 * Copyright: 2015~2021
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2021-01-13 14-22-57
 * @since V1.0
 */
@Setter
@Getter
@ToString
public class CompanyServicePackagePubDTO {

    /**
     * relationshipId 绑定关系的ID
     */
    private Long relationShipId;
    /**
     * 租户ID
     */
    private Long tenantId;
    /**
     * 公司Id
     */
    private Long companyId;
    /**
     * 产品服务包名称
     */
    private Long servicePackageId;
    /**
     * 产品服务包名称 0 停用,1 启用
     */
    private Integer servicePackageStatus;
    /**
     * 0，未绑定，1 绑定
     */
    private Integer bindStatus;
}
