package com.xforceplus.business.company.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * @author chenpengpeng
 * 接收税件发送消息结构体，同时也是集成平台回调接口入参结构体
 */

@Data
@ApiModel("税件推送公司纳税人性质及限额信息")
public class CompanyTaxwareDto {
    @ApiModelProperty("税号")
    private String taxCode;

    @ApiModelProperty("税盘编号")
    private String deviceNo;

    @ApiModelProperty("开税机号")
    private String invoicingMachineNo;

    @ApiModelProperty("设备唯一码")
    private String deviceUn;

    @ApiModelProperty("纳税人性质,NormalTaxPayer,SmallTaxPayer")
    private String natureTaxPayer;

    @ApiModelProperty("发票类型和限额信息")
    private List<LimitInfo> limitInfoList;
}


