package com.xforceplus.business.company.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;

/**
 * @author chenpengpeng
 */
@Data
@ApiModel("发票限额信息")
public class LimitInfo {
    @ApiModelProperty("发票类型，c,ce,s,se,v,vs,ju")
    private String invoiceType;

    @ApiModelProperty("离线时间(小时)")
    private BigDecimal offLineTimeLimit;

    @ApiModelProperty("离线金额(元)")
    private BigDecimal offLineAmountLimit;

    @ApiModelProperty("单张开票限额(元)")
    private BigDecimal singleAmountLimit;

    @ApiModelProperty("锁死期(yyyyMMdd)")
    private String lockTime;

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = StringUtils.trim(invoiceType);
    }

    public void setLockTime(String lockTime) {
        this.lockTime = StringUtils.trim(lockTime);
    }
}
