/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: CompanyConfig.java   2020-09-21 13-57-38
 * Author: Evan
 */
package com.xforceplus.business.company.service;

import com.xforceplus.business.excel.BusinessAttribute;
import com.xforceplus.business.excel.ExcelSheet;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * <p>
 * Title: 服务配置Excel定义
 * </p>
 * <p>
 * Description: 服务配置Excel定义
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-09-21 13-57-38
 * @since V1.0
 */
public final class CompanyConfigExcel {

    private CompanyConfigExcel(){

    }

    /**
     * 默认Excel文件{@value}
     */
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "template/company/serviceConfigExport.xlsx";
    /**
     * 默认排序字段{@value}
     */
    public static final String SORT_FIELD = "createTime";
    /**
     * 业务名称
     */
    public static final String BUSINESS_NAME = "服务配置";
    /**
     * 默认服务配置表名
     */
    public static final String SN_COMPANY_CONFIG = "服务配置";
    /**
     * 过滤的字段
     */
    public static final String TAX_NUM = "taxNum";
    /**
     *  每次导入1000条数据
     */
    public static final int IMPORT_BATCH_SIZE = 1000;

    /**
     * 服务醘
     */
    private static final List<ExcelSheet> SHEETS = Stream
            .of(new ExcelSheet(0, SN_COMPANY_CONFIG))
            .collect(Collectors.toList());

    /**
     * 构建导入导出属性
     */
    public static final BusinessAttribute COMPANY_CONFIG_EXCEL_ATTRIBUTE = BusinessAttribute
            .builder()
            .name(BUSINESS_NAME)
            .batchSize(IMPORT_BATCH_SIZE)
            .exportTemplateFile(DEFAULT_TEMPLATE_FILE_NAME)
            .sheets(SHEETS)
            .build();

    /**
     * 获取ExcelSheet
     *
     * @return List<ExcelSheet> ExcelSheet列表
     */
    public static List<ExcelSheet> getSheets() {
        return SHEETS;
    }
}
