/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: CompanyExcel.java   2020-09-22 10-19-08
 * Author: Evan
 */
package com.xforceplus.business.company.service;

import com.xforceplus.business.excel.BusinessAttribute;
import com.xforceplus.business.excel.ExcelSheet;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * <p>
 * Title:
 * </p>
 * <p>
 * Description:
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-09-22 10-19-08
 * @since V1.0
 */
public final class CompanyExcel {


    private CompanyExcel(){

    }

    /**
     * 默认Excel文件{@value}
     */
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "template/company/companyExport.xlsx";

    /**
     * 默认Excel文件{@value}
     */
    public static final String ORG_EXPORT_TEMPLATE_FILE_NAME = "template/company/ ";
    /**
     * 默认排序字段{@value}
     */
    public static final String SORT_FIELD = "createTime";
    /**
     * 业务名称
     */
    public static final String BUSINESS_NAME = "公司信息";

    /**
     * 默认服务配置表名
     */
    public static final String SN_COMPANY = "公司信息";

    public static final String BUSINESS_NAME_ORG_COMPANY_NUM = "公司编号导入";

    public static final String BUSINESS_NAME_ORG_EXTENSION = "公司扩展信息";
    /**
     * 过滤的字段
     */
    public static final String TAX_NUM = "taxNum";
    /**
     * 默认导入的数据：{@value}
     */
    public static final Integer IMPORT_BATCH_SIZE = 3000;

    /**
     * 服务醘
     */
    private static final List<ExcelSheet> SHEETS = Stream.of(new ExcelSheet(0, SN_COMPANY)).collect(Collectors.toList());
    private static final List<ExcelSheet> BUSINESS_NAME_ORG_COMPANY_NUM_SHEETS = Stream.of(new ExcelSheet(0, BUSINESS_NAME_ORG_COMPANY_NUM)).collect(Collectors.toList());

    /**
     * 构建导入导出属性
     */
    public static final BusinessAttribute COMPANY_EXCEL_ATTRIBUTE = BusinessAttribute
            .builder()
            .name(BUSINESS_NAME)
            .batchSize(IMPORT_BATCH_SIZE)
            .exportTemplateFile(DEFAULT_TEMPLATE_FILE_NAME)
            .sheets(SHEETS)
            .build();


    /**
     * 构建导入导出属性
     */
    public static final BusinessAttribute ORG_COMPANY_NUM_IMPORT_ATTRIBUTE = BusinessAttribute
            .builder()
            .name(BUSINESS_NAME_ORG_COMPANY_NUM)
            .batchSize(IMPORT_BATCH_SIZE)
            .exportTemplateFile(ORG_EXPORT_TEMPLATE_FILE_NAME)
            .sheets(BUSINESS_NAME_ORG_COMPANY_NUM_SHEETS)
            .build();

    /**
     * 构建导入导出属性
     */
    public static final BusinessAttribute ORG_EXTENSION_IMPORT_ATTRIBUTE = BusinessAttribute
            .builder()
            .name(BUSINESS_NAME_ORG_EXTENSION)
            .batchSize(IMPORT_BATCH_SIZE)
            .exportTemplateFile(ORG_EXPORT_TEMPLATE_FILE_NAME)
            .sheets(SHEETS)
            .build();

    /**
     * 获取ExcelSheet
     *
     * @return List<ExcelSheet> ExcelSheet列表
     */
    public static List<ExcelSheet> getSheets() {
        return SHEETS;
    }
}
