/*
 * Copyright (c)  2015~2021, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: CompanyHisService.java   2021-01-12 15-45-24
 * Author: Evan
 */
package com.xforceplus.business.company.service;

import com.xforceplus.domain.company.CompanyHisDTO;
import com.xforceplus.entity.Company;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.Optional;

/**
 * <p>
 * Title:  公司履历 Service 定义
 * </p>
 * <p>
 * Description:  公司履历 Service 定义
 * </p>
 * <p>
 * Copyright: 2015~2021
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2021-01-12 15-45-24
 * @since V1.0
 */
public interface CompanyHistoryService {

    /**
     * 根据公司履历的税号查询当前公司信息
     *
     * @param taxNum 税号
     * @return Optional<Company>
     */
    Optional<Company> findByHisTaxNum(String taxNum);

    /**
     * 分页查询
     *
     * @param taxNum   税号
     * @param pageable 分页查询
     * @return Page<CompanyHisDTO>
     */
    Page<CompanyHisDTO> pageHistory(String taxNum, Pageable pageable);
}
