package com.xforceplus.business.company.service;

import com.xforceplus.business.excel.BusinessAttribute;
import com.xforceplus.business.excel.ExcelSheet;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author Xin
 */
public class CompanyPackageExcel {

    private CompanyPackageExcel(){

    }

    /**
     * 默认Excel文件{@value}
     */
    public static final String DEFAULT_TEMPLATE_FILE_NAME = "template/company/companyServiceExport.xlsx";

    /**
     * 默认服务配置表名
     */
    public static final String SN_COMPANY_PACKAGE = "公司服务包列表";
    /**
     * 业务名称
     */
    public static final String BUSINESS_NAME = "公司服务包列表";

    /**
     * 默认导入的数据：{@value}
     */
    public static final Integer IMPORT_BATCH_SIZE = 1000;

    /**
     * 工作薄
     */
    private static final List<ExcelSheet> SHEETS = Stream.of(new ExcelSheet(0, SN_COMPANY_PACKAGE)).collect(Collectors.toList());
    /**
     * 构建导入导出属性
     */
    public static final BusinessAttribute ATTRIBUTE = BusinessAttribute
            .builder()
            .name(BUSINESS_NAME)
            .batchSize(IMPORT_BATCH_SIZE)
            .exportTemplateFile(DEFAULT_TEMPLATE_FILE_NAME)
            .sheets(SHEETS)
            .build();

    /**
     * 获取ExcelSheet
     *
     * @return List<ExcelSheet> ExcelSheet列表
     */
    public static List<ExcelSheet> getSheets() {
        return SHEETS;
    }
}
