package com.xforceplus.business.company.service;

import com.xforceplus.api.model.CompanyTenantRelModel;
import com.xforceplus.dao.*;
import com.xforceplus.entity.Company;
import com.xforceplus.entity.CompanyTenantRel;
import com.xforceplus.entity.OrgStruct;
import com.xforceplus.entity.OrgUserRel;
import com.xforceplus.query.CompanyTenantRelQueryHelper;
import io.geewit.data.jpa.essential.domain.EntityGraphs;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Optional;

/**
 * @author duanhy
 * @date 2022/1/13 13:38
 */
@Service
public class CompanyProcess {

    public CompanyProcess(CompanyTenantRelOperationService companyTenantRelOperationService, CompanyService companyService, CompanyDao companyDao, OrgStructDao orgStructDao, CompanyTenantRelDao companyTenantRelDao, OrgUserRelDao orgUserRelDao, TenantCompanyRelDao tenantCompanyRelDao) {
        this.companyTenantRelOperationService = companyTenantRelOperationService;
        this.companyService = companyService;
        this.companyDao = companyDao;
        this.orgStructDao = orgStructDao;
        this.companyTenantRelDao = companyTenantRelDao;
        this.orgUserRelDao = orgUserRelDao;
        this.tenantCompanyRelDao = tenantCompanyRelDao;
    }

    private final CompanyTenantRelOperationService companyTenantRelOperationService;

    private final CompanyService companyService;
    private final CompanyDao companyDao;
    private final OrgStructDao orgStructDao;
    private final CompanyTenantRelDao companyTenantRelDao;
    private final OrgUserRelDao orgUserRelDao;
    private final TenantCompanyRelDao tenantCompanyRelDao;

    @Transactional(rollbackFor = Exception.class)
    public void removeTenant(Long companyId, Long tenantId) {
        Company company = companyService.findById(companyId);
        List<OrgStruct> orgStructs = orgStructDao.findByCompanyId(companyId);
        if (CollectionUtils.isEmpty(orgStructs)) {
            throw new IllegalArgumentException("公司没有对应的组织，请检查！");
        }
        if (orgStructs.stream().noneMatch(o -> o.getTenantId().equals(tenantId))) {
            throw new IllegalArgumentException("当前公司与租户没有建立所属关系！");
        }
        //单租户
        OrgStruct orgStruct;
        if (orgStructs.size() == 1) {
            orgStruct = orgStructs.get(0);
            company.setHostTenantId(null);
            companyDao.saveAndFlush(company);
            //多租户
        } else {
            if (tenantId.equals(company.getHostTenantId())) {
                throw new IllegalArgumentException("公司为多租户，不能直接移除与“所属租户“的关系！");
            }
            orgStruct = orgStructs.stream().filter(o -> o.getTenantId().equals(tenantId)).findFirst().orElseThrow(() -> new IllegalArgumentException("没有比配租户id(" + tenantId + ")的组织"));
        }
        List<OrgStruct> childes = orgStructDao.findChildesByParentId(orgStruct.getOrgId());
        if (!CollectionUtils.isEmpty(childes)) {
            throw new IllegalArgumentException("公司对应的组织存在子组织，请处理！");
        }
        List<OrgUserRel> orgUserRels = orgUserRelDao.findByOrgId(orgStruct.getOrgId());
        if (!CollectionUtils.isEmpty(orgUserRels)) {
            throw new IllegalArgumentException("公司对应的组织存在关联人员，请处理！");
        }
        //授权的关联关系
        CompanyTenantRelModel.Request.Query companyTenantRelQuery = new CompanyTenantRelModel.Request.Query();
        companyTenantRelQuery.setCompanyId(companyId);
        List<CompanyTenantRel> companyTenantRels = companyTenantRelDao.findAll(CompanyTenantRelQueryHelper.querySpecification(companyTenantRelQuery), EntityGraphs.named(CompanyTenantRel.NAMED_ENTITY_GRAPH_DEFAULT));
        Optional<CompanyTenantRel> optionalCompanyTenantRel = companyTenantRels.stream().filter(r -> r.getRelatedTenantId().equals(tenantId)).findFirst();
        if (optionalCompanyTenantRel.isPresent()) {
            companyTenantRelDao.deleteById(optionalCompanyTenantRel.get().getId());
            companyTenantRelOperationService.saveUnrelateOperation(company, optionalCompanyTenantRel.get());
        }
        tenantCompanyRelDao.deleteByTenantIdAndCompanyId(orgStruct.getTenantId(), companyId);
        orgStructDao.delete(orgStruct);
    }
}
