/*
 * Copyright (c)  2015~2020, xforceplus
 * All rights reserved.
 * Project:tenant-service
 * Id: CompanyServicePackageExcelExportServiceImpl.java   2020-10-27 11-17-46
 * Author: Evan
 */
package com.xforceplus.business.company.service;

import com.xforceplus.api.model.CompanyServiceRelModel;
import com.xforceplus.business.excel.BusinessType;
import com.xforceplus.business.excel.SimpleExcelWriter;
import com.xforceplus.business.excel.company.CompanyPackageDTO;
import com.xforceplus.business.excel.reader.Context;
import com.xforceplus.business.excel.writer.ExcelConfigBusinessType;
import com.xforceplus.business.service.ExcelWriteService;
import com.xforceplus.tenant.core.exception.UnknownException;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

import static com.xforceplus.business.company.service.CompanyPackageExcel.SN_COMPANY_PACKAGE;
import static com.xforceplus.business.excel.ExcelFile.PARAMS_QUERY;

/**
 * <p>
 * Title: 公司服务包配置ExcelExport
 * </p>
 * <p>
 * Description: 公司服务包配置ExcelExport
 * </p>
 * <p>
 * Copyright: 2015~2020
 * </p>
 * <p>
 * Company/Department: xforceplus
 * </p>
 *
 * @author Evan
 * <b>Creation Time:</b> 2020-10-27 11-17-46
 * @since V1.0
 */
@Service
public class CompanyServicePackageExcelExportServiceImpl implements ExcelWriteService {


    private final CompanyServicePackageService companyServicePackageService;

    public CompanyServicePackageExcelExportServiceImpl(CompanyServicePackageService companyServicePackageService) {
        this.companyServicePackageService = companyServicePackageService;
    }

    /**
     * 获取导入类型，用于Event事件调整导入方法
     * @return ImportBusinessType
     */
    @Override
    public BusinessType getBusinessType() {
        return ExcelConfigBusinessType.COMPANY_PACKAGE_IMPORT;
    }

    /**
     * 导出公共方法
     *
     * @param context 上下文
     * @return Context
     */
    @Override
    public void write(Context context) {
        CompanyServiceRelModel.Request.CompanyPackageExport export = context.getParam(PARAMS_QUERY, CompanyServiceRelModel.Request.CompanyPackageExport.class);
        SimpleExcelWriter simpleExcelWriter = context.getSimpleExcelWriter();
        List<CompanyPackageDTO> companyPackageDTOList = companyServicePackageService.getBatchExportData(export.getCompanyIds(), export.getTenantIds());
        if (CollectionUtils.isEmpty(companyPackageDTOList)) {
            throw new UnknownException("导出失败，没有获取到公司");
        }

        String[] sheetNames = export.getSheets();

        for (String sheetName : sheetNames) {
            //等于公司服务配置信息，则分页读取公司信息
            if (SN_COMPANY_PACKAGE.equals(sheetName)) {
                simpleExcelWriter.fill(sheetName, companyPackageDTOList);
            }
        }
    }
}
