package com.xforceplus.business.company.service;

import com.xforceplus.business.excel.BusinessAttribute;
import com.xforceplus.business.excel.ExcelSheet;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author wanglijun
 */
public final class CompanyUpdateConfigExcel {

    private CompanyUpdateConfigExcel(){

    }


    /**
     * 导出Excel模板文件{@value}
     */
    public static final String EXPORT_TEMPLATE_FILE_NAME = "无导出业务";

    /**
     * 导入功能模板文件：{@value}
     */
    public static final String IMPORT_TEMPLATE_FILE_NAME = "";


    public static final String SN_COMPANY_CONFIG = "公司批量修改";

    /**
     * 业务名称
     */
    public static final String BUSINESS_NAME = "公司批量修改";

    /**
     *  每次导入1000条数据
     */
    public static final int IMPORT_BATCH_SIZE = 1000;

    /**
     * 服务醘
     */
    private static final List<ExcelSheet> SHEETS = Stream.
            of(new ExcelSheet(0, SN_COMPANY_CONFIG))
            .collect(Collectors.toList());
    /**
     * 构建导入导出属性
     */
    public static final BusinessAttribute ATTRIBUTE = BusinessAttribute
            .builder()
            .name(BUSINESS_NAME)
            .batchSize(IMPORT_BATCH_SIZE)
            .exportTemplateFile(EXPORT_TEMPLATE_FILE_NAME)
            .importTemplateFile(IMPORT_TEMPLATE_FILE_NAME)
            .sheets(SHEETS)
            .build();

    /**
     * 获取ExcelSheet
     *
     * @return List<ExcelSheet> ExcelSheet列表
     */
    public static List<ExcelSheet> getSheets() {
        return SHEETS;
    }
}
