package com.xforceplus.business.company.service;

import com.xforceplus.api.model.TenantCompanyRelModel.Request;
import com.xforceplus.dao.CompanyDao;
import com.xforceplus.dao.OrgStructDao;
import com.xforceplus.dao.TenantCompanyRelDao;
import com.xforceplus.entity.TenantCompanyRel;
import com.xforceplus.query.TenantCompanyRelQueryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 公司租户关联关系 Service
 *
 * @author geewit
 */
@Service
public class TenantCompanyRelService {
    private final static Logger logger = LoggerFactory.getLogger(TenantCompanyRelService.class);

    private final TenantCompanyRelDao tenantCompanyRelDao;
    @Autowired
    private OrgStructDao orgDao;
    @Autowired
    private CompanyDao companyDao;

    public TenantCompanyRelService(TenantCompanyRelDao tenantCompanyRelDao) {
        this.tenantCompanyRelDao = tenantCompanyRelDao;
    }

    public Page<TenantCompanyRel> page(Request.Query query, Pageable pageable) {
        Specification<TenantCompanyRel> specification = TenantCompanyRelQueryHelper.querySpecification(query);
        Page<TenantCompanyRel> page = tenantCompanyRelDao.findAll(specification, pageable);
        return page;
    }

    public List<TenantCompanyRel> list(Request.Query query, Sort sort) {
        Specification<TenantCompanyRel> specification = TenantCompanyRelQueryHelper.querySpecification(query);
        List<TenantCompanyRel> list = tenantCompanyRelDao.findAll(specification, sort);
        return list;
    }

    public List<TenantCompanyRel> list(Specification<TenantCompanyRel> specification, Sort sort) {
        return tenantCompanyRelDao.findAll(specification, sort);
    }




    public TenantCompanyRel findById(long relId) {
        return tenantCompanyRelDao.findById(relId).orElseThrow(() -> new IllegalArgumentException("未找到租户公司关联关系实体"));
    }
}
